/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.server;

import com.alibaba.dubbo.rpc.dubbo.internal.DubboRequest;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.TbRemotingRequest;
import com.taobao.hsf.remoting.TbRemotingResponse;
import com.taobao.hsf.remoting.adaptor.tbremoting.HeartBeatProcessor;
import com.taobao.hsf.remoting.adaptor.tbremoting.ProcessorUtil;
import com.taobao.hsf.remoting.adaptor.tbremoting.RequestProcessor;
import com.taobao.hsf.remoting.server.RpcRequestProcessor;
import com.taobao.hsf.remoting.server.ServerHandler;
import com.taobao.hsf.remoting.server.output.TbRemotingOutput;
import com.taobao.hsf.remoting.util.RemotingUtil;
import com.taobao.hsf.util.InetAddressUtil;
import com.taobao.middleware.logger.Logger;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.locale.LogResources;
import com.taobao.remoting.serialize.impl.DeserializeException;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

public class TbRemotingHandler
implements ServerHandler<TbRemotingRequest> {
    private static final Logger LOGGER = LoggerInit.LOGGER_REMOTING;
    private static final String DESERIALIZATION_REQUEST_ERROR = "deserialization request error on server side:";
    private static final ProcessorUtil processors = new ProcessorUtil();
    private final RpcRequestProcessor rpcRequestProcessor;
    private final ThreadPoolExecutor defaultThreadPool;

    public TbRemotingHandler(RpcRequestProcessor rpcRequestProcessor) {
        this.rpcRequestProcessor = rpcRequestProcessor;
        this.defaultThreadPool = rpcRequestProcessor.getThreadPoolManager().getDefaultPoolExecutor();
        HeartBeatProcessor heartBeatProcessor = new HeartBeatProcessor();
        this.registerProcessor(heartBeatProcessor.interest(), heartBeatProcessor);
    }

    private void registerProcessor(String className, Object instance) {
        processors.registerProcessor((RequestProcessor)instance);
    }

    @Override
    public void handleRequest(TbRemotingRequest request, final Connection connection, final long startTime) {
        ConnectionRequest connectionRequest;
        final byte protocol = request.getCodecType();
        try {
            connectionRequest = RemotingConstants.CONN_REQUEST_SERIALIZER.deserialize(request.getRequestInputStream(), protocol);
        }
        catch (DeserializeException ioe) {
            LoggerInit.LOGGER_REMOTING.error("", DESERIALIZATION_REQUEST_ERROR, (Throwable)ioe);
            ConnectionRequest requestError = ioe.getRequest();
            if (null != requestError) {
                ConnectionResponse resp = ConnectionResponse.getResponse((ConnectionRequest)requestError);
                resp.setResult(4);
                resp.setErrorMsg(MessageFormat.format("[HSF-Provider-{0}] Error log: {1}", InetAddressUtil.getIP(), ioe.getMessage()));
                SliceOutputStream os = new SliceOutputStream();
                try {
                    RemotingConstants.CONN_RESPONSE_SERIALIZER.serialize(resp, protocol, (OutputStream)os);
                    connection.writeReponseToChannel(new TbRemotingResponse(os));
                    return;
                }
                catch (IOException e1) {
                    LOGGER.error("", "[Remoting Error]", (Throwable)e1);
                    throw new RuntimeException(e1);
                }
            }
            throw new RuntimeException(ioe);
        }
        Executor trueExecutor = this.getTrueExecutor(connectionRequest);
        if (trueExecutor == this.defaultThreadPool) {
            this.processTbRemotingResponse(connection, connectionRequest, protocol, startTime);
        } else {
            trueExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    TbRemotingHandler.this.processTbRemotingResponse(connection, connectionRequest, protocol, startTime);
                }
            });
        }
    }

    private void processTbRemotingResponse(Connection connection, ConnectionRequest connectionRequest, byte protocol, long startTime) {
        Object appRequest = connectionRequest.getAppRequest();
        if (appRequest instanceof HSFRequest) {
            ((HSFRequest)appRequest).setSerializeType(connectionRequest.getSerializeProtocol());
            TbRemotingOutput rpcOutputStream = new TbRemotingOutput(connection, connectionRequest, false, startTime);
            this.rpcRequestProcessor.handleRequest((HSFRequest)appRequest, rpcOutputStream);
        } else if (appRequest instanceof DubboRequest) {
            HSFRequest convertedHSFRequest = RemotingUtil.convert((DubboRequest)appRequest);
            convertedHSFRequest.setSerializeType(connectionRequest.getSerializeProtocol());
            TbRemotingOutput rpcOutputStream = new TbRemotingOutput(connection, connectionRequest, true, startTime);
            this.rpcRequestProcessor.handleRequest(convertedHSFRequest, rpcOutputStream);
        } else {
            ConnectionResponse connRsp = new ConnectionResponse();
            connRsp.setRequestId(connectionRequest.getId());
            connRsp.setDirection(connectionRequest.getDirection());
            connRsp.setSerializeProtocol(connectionRequest.getSerializeProtocol());
            RequestProcessor<?> processor = this.findProcessor(appRequest);
            if (null == processor) {
                Class<?> appReqType = appRequest.getClass();
                String msg = LogResources.getLog((String)"requestProcessorNotFound", (Object[])new Object[]{appReqType.getName()});
                LOGGER.error("", msg);
                connRsp.setResult(1);
                connRsp.setErrorMsg(msg);
            } else {
                connRsp.setAppResponse(processor.handleRequest(appRequest));
            }
            try {
                SliceOutputStream os = new SliceOutputStream();
                RemotingConstants.CONN_RESPONSE_SERIALIZER.serialize(connRsp, protocol, (OutputStream)os);
                connection.writeReponseToChannel(new TbRemotingResponse(os));
            }
            catch (Exception e) {
                LOGGER.error("", "[Remoting Error]", (Throwable)e);
                ConnectionResponse connectionErrorResponse = ConnectionResponse.getResponse((ConnectionRequest)connectionRequest);
                connectionErrorResponse.setResult(1);
                connectionErrorResponse.setErrorMsg("Error on serialize response:" + InetAddressUtil.getIP());
                SliceOutputStream os = new SliceOutputStream();
                try {
                    RemotingConstants.CONN_RESPONSE_SERIALIZER.serialize(connectionErrorResponse, protocol, (OutputStream)os);
                    connection.writeReponseToChannel(new TbRemotingResponse(os));
                }
                catch (IOException e1) {
                    LOGGER.error("", "[Remoting Error]", (Throwable)e1);
                    connection.writeReponseToChannel(new TbRemotingResponse(os));
                }
            }
        }
    }

    @Override
    public Executor getExecutor(TbRemotingRequest request) {
        return this.rpcRequestProcessor.getThreadPoolManager().getDefaultPoolExecutor();
    }

    private Executor getTrueExecutor(ConnectionRequest request) {
        Object appRequest = request.getAppRequest();
        if (appRequest instanceof HSFRequest) {
            return this.rpcRequestProcessor.getExecutor(((HSFRequest)appRequest).getTargetServiceUniqueName());
        }
        if (appRequest instanceof DubboRequest) {
            return this.rpcRequestProcessor.getExecutor(((DubboRequest)appRequest).getServiceName() + ":" + ((DubboRequest)appRequest).getServiceVersion());
        }
        RequestProcessor<?> processor = this.findProcessor(appRequest);
        return processor.getExecutor(appRequest);
    }

    public RequestProcessor<?> findProcessor(Object appRequest) {
        return processors.findProcessor(appRequest.getClass().getName());
    }
}

