/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.server.output;

import com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import com.alibaba.dubbo.common.serialize.ObjectOutput;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.Dubbo2Request;
import com.taobao.hsf.remoting.Dubbo2Response;
import com.taobao.hsf.remoting.ResponseStatus;
import com.taobao.hsf.remoting.server.output.ServerOutput;
import java.io.OutputStream;

public final class DubboRemotingOutput
extends ServerOutput {
    public static final byte RESPONSE_WITH_EXCEPTION = 0;
    public static final byte RESPONSE_VALUE = 1;
    public static final byte RESPONSE_NULL_VALUE = 2;
    private final Dubbo2Request request;

    public DubboRemotingOutput(Connection connection, Dubbo2Request request, long startTime) {
        super(connection, startTime);
        this.request = request;
    }

    @Override
    public int writeHSFResponse(HSFResponse hsfResponse) {
        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
        byte codeType = this.request.getCodecType();
        ObjectOutput objectOutput = null;
        try {
            objectOutput = CodecSupport.getSerializationById((Byte)codeType).serialize(null, (OutputStream)os);
            ResponseStatus status = ResponseStatus.OK;
            if (hsfResponse.isError()) {
                objectOutput.writeByte((byte)0);
                objectOutput.writeObject((Object)new Exception(hsfResponse.getErrorMsg()));
                status = ResponseStatus.BAD_REQUEST;
            } else {
                Object result = hsfResponse.getAppResponse();
                if (result == null) {
                    objectOutput.writeByte((byte)2);
                } else {
                    if (result instanceof Throwable) {
                        objectOutput.writeByte((byte)0);
                    } else {
                        objectOutput.writeByte((byte)1);
                    }
                    objectOutput.writeObject(result);
                }
            }
            objectOutput.flushBuffer();
            Dubbo2Response response = new Dubbo2Response(this.request.getRequestID(), this.request.getVersion(), os.toByteArray(), codeType);
            response.setStatus(status);
            this.connection.writeReponseToChannel(response);
        }
        catch (Throwable e) {
            LoggerInit.LOGGER_REMOTING.error("", "server handle request error", e);
            try {
                if (objectOutput != null) {
                    objectOutput.writeByte((byte)0);
                    objectOutput.writeObject((Object)e);
                    objectOutput.flushBuffer();
                }
                Dubbo2Response response = new Dubbo2Response(this.request.getRequestID(), this.request.getVersion(), os.toByteArray(), codeType);
                response.setStatus(ResponseStatus.SERVER_ERROR);
                this.connection.writeReponseToChannel(response);
            }
            catch (Exception e1) {
                Dubbo2Response response = new Dubbo2Response(this.request.getRequestID(), this.request.getVersion(), null, codeType);
                response.setStatus(ResponseStatus.UNKNOW_CODE);
                this.connection.writeReponseToChannel(response);
            }
        }
        return os.size();
    }
}

