/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.server.output;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.remoting.Connection;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.TbRemotingResponse;
import com.taobao.hsf.remoting.server.output.ServerOutput;
import com.taobao.hsf.remoting.util.RemotingUtil;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.impl.ConnectionResponse;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class TbRemotingOutput
extends ServerOutput {
    private final ConnectionRequest connectionRequest;
    private final boolean isDubboRequest;

    public TbRemotingOutput(Connection connection, ConnectionRequest connectionRequest, boolean isDubboRequest, long startTime) {
        super(connection, startTime);
        this.connectionRequest = connectionRequest;
        this.isDubboRequest = isDubboRequest;
    }

    @Override
    public int writeHSFResponse(HSFResponse object) {
        int responseSize = 0;
        try {
            ConnectionResponse connectionResponse = ConnectionResponse.getResponse((ConnectionRequest)this.connectionRequest);
            if (this.isDubboRequest) {
                connectionResponse.setAppResponse((Object)RemotingUtil.convert2DubboResponse(object));
            } else {
                connectionResponse.setAppResponse((Object)object);
            }
            SliceOutputStream os = new SliceOutputStream();
            RemotingConstants.CONN_RESPONSE_SERIALIZER.serialize(connectionResponse, this.connectionRequest.getSerializeProtocol(), (OutputStream)os);
            responseSize = os.size();
            this.connection.writeReponseToChannel(new TbRemotingResponse(os));
        }
        catch (Exception e) {
            LoggerInit.LOGGER_REMOTING.error("", "[Remoting Error]", (Throwable)e);
            ConnectionResponse errorResponse = ConnectionResponse.getResponse((ConnectionRequest)this.connectionRequest);
            HSFResponse response = new HSFResponse();
            response.setErrorMsg("Error on serialize response");
            errorResponse.setAppResponse((Object)response);
            SliceOutputStream os = new SliceOutputStream();
            try {
                RemotingConstants.CONN_RESPONSE_SERIALIZER.serialize(errorResponse, this.connectionRequest.getSerializeProtocol(), (OutputStream)os);
                responseSize = os.size();
                this.connection.writeReponseToChannel(new TbRemotingResponse(os));
            }
            catch (IOException e1) {
                LoggerInit.LOGGER_REMOTING.error("", "[Remoting Error]", (Throwable)e1);
                this.connection.writeReponseToChannel(new TbRemotingResponse(os));
            }
        }
        return responseSize;
    }
}

