/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.util;

import com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import com.alibaba.dubbo.common.serialize.ObjectOutput;
import com.alibaba.dubbo.common.serialize.Serialization;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.dubbo.internal.DubboRequest;
import com.alibaba.dubbo.rpc.dubbo.internal.DubboResponse;
import com.taobao.hsf.CustomizedSerializerHelper;
import com.taobao.hsf.domain.HSFRequest;
import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.model.metadata.MethodSpecial;
import com.taobao.hsf.remoting.BaseRequest;
import com.taobao.hsf.remoting.Dubbo2Request;
import com.taobao.hsf.remoting.RemotingConstants;
import com.taobao.hsf.remoting.RemotingURL;
import com.taobao.hsf.remoting.RpcRequest;
import com.taobao.hsf.remoting.TbRemotingRequest;
import com.taobao.hsf.remoting.exception.RemotingUncheckedException;
import com.taobao.hsf.remoting.serialize.Codecs;
import com.taobao.hsf.remoting.serialize.Encoder;
import com.taobao.hsf.remoting.util.UUIDGenerator;
import com.taobao.hsf.util.ClassUtils;
import com.taobao.remoting.impl.ConnectionRequest;
import com.taobao.remoting.serialize.impl.SliceOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RemotingUtil {
    private static final char AND = '&';
    private static final String RPC_CONTEXT = "rc";

    public static TbRemotingRequest convert2TbRemotingRequest(HSFRequest appRequest, byte codecType, int timeOut) throws Exception {
        ConnectionRequest request = new ConnectionRequest((Object)appRequest);
        request.setSerializeProtocol(codecType);
        SliceOutputStream os = new SliceOutputStream();
        RemotingConstants.CONN_REQUEST_SERIALIZER.serialize(request, codecType, (OutputStream)os);
        return new TbRemotingRequest(os, request.getMessageId(), codecType, timeOut);
    }

    public static Dubbo2Request convert2Dubbo2Request(HSFRequest hsfRequest, byte codecType, int timeout, RemotingURL url) throws Exception {
        Map context;
        String dubboSerializationType = url.getParameter("serialization", "hessian2");
        codecType = CodecSupport.getIDByDesc((String)dubboSerializationType);
        Serialization serialization = CodecSupport.getSerializationById((Byte)codecType);
        if (serialization == null) {
            throw new RemotingUncheckedException(102, codecType + "");
        }
        UnsafeByteArrayOutputStream os = new UnsafeByteArrayOutputStream();
        RpcInvocation appRequest = new RpcInvocation(hsfRequest.getMethodName(), hsfRequest.getParameterClasses(), hsfRequest.getMethodArgs());
        appRequest.setAttachment("path", url.getPath());
        if (url.hasParameter("interface")) {
            appRequest.setAttachment("interface", url.getParameter("interface"));
        }
        if (url.hasParameter("group")) {
            appRequest.setAttachment("group", url.getParameter("group"));
        }
        if (url.hasParameter("version")) {
            appRequest.setAttachment("version", url.getParameter("version", "0.0.0"));
        }
        if (url.hasParameter("timeout")) {
            appRequest.setAttachment("timeout", url.getParameter("timeout"));
        }
        if (url.hasParameter("token")) {
            appRequest.setAttachment("token", url.getParameter("token"));
        }
        if (url.hasParameter("application")) {
            appRequest.setAttachment("application", url.getParameter("application"));
        }
        if ((context = RpcContext.getContext().getAttachments()) != null) {
            appRequest.addAttachmentsIfAbsent(context);
        }
        ObjectOutput objectOutput = serialization.serialize(null, (OutputStream)os);
        RemotingUtil.encodeRequestData(objectOutput, appRequest);
        objectOutput.flushBuffer();
        Dubbo2Request request = new Dubbo2Request(UUIDGenerator.getNextOpaque(), "2.5.4", os.toByteArray(), codecType, timeout);
        return request;
    }

    public static TbRemotingRequest convert2Dubbo1Request(HSFRequest hsfRequest, RemotingURL url, int timeOut) throws Exception {
        String methodName = hsfRequest.getMethodName();
        Object[] args = hsfRequest.getMethodArgs();
        String[] ptns = hsfRequest.getMethodArgSigs();
        if ("$invoke".equals(methodName)) {
            methodName = ":" + (String)args[0];
            ptns = (String[])args[1];
            args = (Object[])args[2];
        }
        String serviceName = url.getPath();
        String group = url.getParameter("group");
        if (group != null && group.length() > 0) {
            serviceName = group + "/" + serviceName;
        }
        DubboRequest dubboReqeuest = new DubboRequest(serviceName, url.getParameter("version"), methodName, ptns, args);
        ConnectionRequest request = new ConnectionRequest((Object)dubboReqeuest);
        request.setSerializeProtocol((byte)4);
        SliceOutputStream os = new SliceOutputStream();
        RemotingConstants.CONN_REQUEST_SERIALIZER.serialize(request, (byte)4, (OutputStream)os);
        return new TbRemotingRequest(os, request.getMessageId(), 4, timeOut);
    }

    private static void encodeRequestData(ObjectOutput out, RpcInvocation inv) throws IOException {
        out.writeUTF(inv.getAttachment("dubbo", "HSF2.0"));
        out.writeUTF(inv.getAttachment("path"));
        out.writeUTF(inv.getAttachment("version"));
        out.writeUTF(inv.getMethodName());
        out.writeUTF(ReflectUtils.getDesc((Class[])inv.getParameterTypes()));
        Object[] args = inv.getArguments();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                out.writeObject(args[i]);
            }
        }
        out.writeObject((Object)inv.getAttachments());
    }

    public static BaseRequest convert2RpcRequest(HSFRequest request, byte codecType, int timeout) throws Exception {
        Object argBytes;
        String targetInstanceName = request.getTargetServiceUniqueName();
        String methodName = request.getMethodName();
        String[] argTypes = request.getMethodArgSigs();
        Object[] args = request.getMethodArgs();
        if (RpcContext.getContext().getAttachments() != null) {
            request.getRequestProps().put(RPC_CONTEXT, RpcContext.getContext().getAttachments());
        }
        Map requestProps = request.getRequestProps();
        byte[] requestPropsBytes = null;
        int requestSize = 0;
        if (codecType != 7) {
            argBytes = new byte[args.length][];
            Encoder encoder = Codecs.getEncoder(codecType);
            int i = 0;
            for (Object object : args) {
                argBytes[i] = encoder.encode(object);
                requestSize += argBytes[i++].length;
            }
            requestPropsBytes = encoder.encode(requestProps);
        } else {
            String methodKey = CustomizedSerializerHelper.catMethodName((String)targetInstanceName, (String)methodName, (String[])argTypes);
            argBytes = CustomizedSerializerHelper.getTransformer((String)methodKey).encodeParameters(args);
            requestPropsBytes = Codecs.REQUESTPROP_ENCODER.encode(requestProps);
        }
        RpcRequest wrapper = new RpcRequest(timeout, targetInstanceName, methodName, argTypes, (byte[][])argBytes, requestPropsBytes, codecType, requestSize);
        return wrapper;
    }

    public static String[] getMethodParameter(Object[] parameters) {
        if (parameters.length == 0) {
            return new String[0];
        }
        String[] result = new String[parameters.length];
        int i = 0;
        for (Object c : parameters) {
            result[i++] = c.getClass().getName();
        }
        return result;
    }

    public static HSFRequest convert(RpcRequest request) throws Exception {
        HSFRequest hsfRequest = new HSFRequest();
        hsfRequest.setSerializeType(request.getCodecType());
        String[] argTypes = request.getArgTypes();
        hsfRequest.setMethodArgSigs(argTypes);
        hsfRequest.setMethodName(request.getMethodName());
        hsfRequest.setTargetServiceUniqueName(request.getTargetInstanceName());
        Object[] requestObjects = null;
        byte serializeType = request.getCodecType();
        byte[][] argsBytes = request.getRequestObjects();
        if (request.getCodecType() != 7) {
            requestObjects = new Object[argsBytes.length];
            for (int i = 0; i < argsBytes.length; ++i) {
                requestObjects[i] = Codecs.getDecoder(serializeType).decode(argsBytes[i], ClassUtils.forName((String)argTypes[i]));
            }
        } else {
            String methodKey = hsfRequest.getMethodKey();
            requestObjects = CustomizedSerializerHelper.getTransformer((String)methodKey).decodeParameters(argsBytes);
        }
        hsfRequest.setMethodArgs(requestObjects);
        Map properties = null;
        byte[] requestProp = request.getRequestProps();
        properties = serializeType != 7 ? (Map)Codecs.getDecoder(serializeType).decode(requestProp, Map.class) : (Map)Codecs.REQUESTPROP_DECODER.decode(requestProp, Map.class);
        hsfRequest.refreshRequestProp(properties);
        if (properties != null && properties.get(RPC_CONTEXT) != null) {
            RpcContext.getContext().setAttachments((Map)properties.get(RPC_CONTEXT));
        }
        return hsfRequest;
    }

    public static HSFRequest convert(RpcInvocation invocation) {
        HSFRequest hsfRequest = new HSFRequest();
        hsfRequest.setSerializeType((byte)1);
        hsfRequest.setMethodArgs(invocation.getArguments());
        Class[] argTypes = invocation.getParameterTypes();
        String[] argTypeStrings = new String[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypeStrings[i] = argTypes[i].getName();
        }
        hsfRequest.setMethodArgSigs(argTypeStrings);
        hsfRequest.setMethodName(invocation.getMethodName());
        try {
            Map properties = invocation.getAttachments();
            for (Map.Entry entry : properties.entrySet()) {
                hsfRequest.setRequestProps((String)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            throw new RemotingUncheckedException(201, (Throwable)e, new String[0]);
        }
        String interfaceName = invocation.getAttachment("interface");
        if (interfaceName == null) {
            interfaceName = invocation.getAttachment("path");
        }
        StringBuilder serverNameBuilder = new StringBuilder(interfaceName).append(":");
        if (StringUtils.isNotBlank((String)invocation.getAttachment("version"))) {
            serverNameBuilder.append(invocation.getAttachment("version"));
        } else {
            serverNameBuilder.append("0.0.0");
        }
        hsfRequest.setTargetServiceUniqueName(serverNameBuilder.toString());
        return hsfRequest;
    }

    public static List<MethodSpecial> getMethodSpecials(String target) {
        ArrayList<MethodSpecial> specials = new ArrayList<MethodSpecial>();
        if (target.contains("#")) {
            for (String str : target.split("&")) {
                MethodSpecial special = MethodSpecial.parseMethodSpecial((String)str);
                if (null == special) continue;
                specials.add(special);
            }
        }
        return specials;
    }

    public static void getMethodSpecialsByDubbo(List<MethodSpecial> specials, Map<String, String> parameters) {
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            String key = param.getKey();
            String value = param.getValue();
            if (!key.endsWith(".timeout")) continue;
            try {
                MethodSpecial special = new MethodSpecial();
                special.setMethodName(key.substring(0, key.indexOf(".")));
                special.setClientTimeout(Long.parseLong(value));
                specials.add(special);
            }
            catch (Exception e) {}
        }
    }

    public static HSFRequest convert(DubboRequest appRequest) {
        HSFRequest hsfRequest = new HSFRequest();
        hsfRequest.setTargetServiceUniqueName(appRequest.getServiceName() + ":" + appRequest.getServiceVersion());
        hsfRequest.setMethodName(appRequest.getMethodName());
        hsfRequest.setMethodArgs(appRequest.getParameters());
        hsfRequest.setMethodArgSigs(appRequest.getParamTypeNames());
        return hsfRequest;
    }

    public static DubboResponse convert2DubboResponse(HSFResponse hsfResponse) {
        DubboResponse dubboResponse = new DubboResponse();
        if (hsfResponse.isError()) {
            dubboResponse.setError(116, hsfResponse.getErrorMsg());
            dubboResponse.setValue(hsfResponse.getAppResponse(), 't');
        } else {
            dubboResponse.setValue(hsfResponse.getAppResponse(), 'r');
        }
        return dubboResponse;
    }
}

