/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.remoting.util;

import com.taobao.hsf.remoting.RemotingConstants;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ThreadLocalCache {
    private static final ThreadLocal<Map<String, byte[]>> STRING2BYTES = new ThreadLocal<Map<String, byte[]>>(){

        @Override
        protected Map<String, byte[]> initialValue() {
            return new HashMap<String, byte[]>(2048);
        }
    };
    private static final ThreadLocal<Map<BytesWrapper, String>> BYTES2STRING = new ThreadLocal<Map<BytesWrapper, String>>(){

        @Override
        protected Map<BytesWrapper, String> initialValue() {
            return new HashMap<BytesWrapper, String>(2048);
        }
    };

    public static byte[] getBytes(String string) {
        Map<String, byte[]> map = STRING2BYTES.get();
        byte[] result = map.get(string);
        if (result != null) {
            return result;
        }
        result = string.getBytes(RemotingConstants.DEFAULT_CHARSET);
        if (map.size() < 10192) {
            map.put(string, result);
        }
        return result;
    }

    public static String getString(byte[] bytes) {
        Map<BytesWrapper, String> map = BYTES2STRING.get();
        String string = map.get(new BytesWrapper(bytes));
        if (string != null) {
            return string;
        }
        string = new String(bytes, RemotingConstants.DEFAULT_CHARSET);
        if (map.size() < 10192) {
            map.put(new BytesWrapper(bytes), string);
        }
        return string;
    }

    private static final class BytesWrapper {
        private final byte[] bytes;

        public BytesWrapper(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return Arrays.equals(this.bytes, ((BytesWrapper)obj).bytes);
        }
    }
}

