/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.address;

import com.taobao.hsf.EnumConfigStyle;
import com.taobao.hsf.address.AddressPool;
import com.taobao.hsf.configuration.service.ConfigurationService;
import com.taobao.hsf.globalrule.GlobalRule;
import com.taobao.hsf.globalrule.VirtualCmRule;
import com.taobao.hsf.logger.LoggerInit;
import com.taobao.hsf.route.component.RouteResultCache;
import com.taobao.hsf.route.component.RouteResultCacheImpl;
import com.taobao.hsf.route.flowcontrol.FlowControlRule;
import com.taobao.hsf.route.service.RouteRule;
import com.taobao.hsf.util.HSFServiceContainer;
import com.taobao.hsf.util.HSFServiceTargetUtil;
import com.taobao.hsf.weighting.WeightingRule;
import com.taobao.middleware.logger.Logger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class AddressBucket {
    private static final String DUBBO = "dubbo";
    private static final Logger LOGGER = LoggerInit.LOGGER;
    private static final String PATTERN_MSG = "[AddressBucket-{0}] Refresh: all amount [{1}], available amount [{2}], local preferred switch [{3}].";
    private final ConfigurationService configurationService = (ConfigurationService)HSFServiceContainer.getInstance(ConfigurationService.class);
    private final String serviceUniqueName;
    private final EnumConfigStyle configStyle;
    private final RouteResultCache routeResultCache;
    private final AddressPool addressPool;
    private volatile FlowControlRule flowControlRule = null;
    private volatile WeightingRule weightingRule = null;
    private volatile Map<String, Integer> rtWeightMap = Collections.emptyMap();
    private volatile List<String> allAddresses = Collections.emptyList();
    private volatile List<String> allDubboAddress = Collections.emptyList();
    private volatile Map<String, String> ip2Addresses = Collections.emptyMap();
    private volatile List<String> localAddresses = Collections.emptyList();
    private final CopyOnWriteArrayList<String> invalidAddresses = new CopyOnWriteArrayList();
    private volatile List<String> availableAddresses = Collections.emptyList();
    private final String unitName;
    volatile AtomicBoolean needRefresh = new AtomicBoolean(false);

    public AddressBucket(String serviceUniqueName, AddressPool addressPool, EnumConfigStyle configStyle) {
        this(null, serviceUniqueName, addressPool, configStyle);
    }

    public AddressBucket(String unitName, String serviceUniqueName, AddressPool addressPool, EnumConfigStyle configStyle) {
        this.unitName = unitName;
        this.serviceUniqueName = serviceUniqueName;
        this.routeResultCache = new RouteResultCacheImpl(unitName, serviceUniqueName);
        this.addressPool = addressPool;
        this.configStyle = configStyle;
    }

    public synchronized List<String> getAvailableAddresses() {
        return new ArrayList<String>(this.availableAddresses);
    }

    public List<String> getInvalidAddresses() {
        return new ArrayList<String>(this.invalidAddresses);
    }

    public synchronized List<String> getLocalAddresses() {
        return new ArrayList<String>(this.localAddresses);
    }

    public synchronized WeightingRule getWeightRule() {
        return this.weightingRule;
    }

    public List<String> getAllAddresses() {
        return new ArrayList<String>(this.getAddressesByConfigStyle());
    }

    private List<String> getAddressesByConfigStyle() {
        if (this.configurationService.isNeedDubboRegistry() && this.configStyle == EnumConfigStyle.DUBBO) {
            if (DUBBO.equalsIgnoreCase(this.configurationService.getDubboRegServer())) {
                return this.allDubboAddress;
            }
            if (this.allAddresses != null && this.allAddresses.size() > 0) {
                return this.allAddresses;
            }
            return this.allDubboAddress;
        }
        return this.allAddresses;
    }

    public synchronized void addInvalidAddress(String serviceUniqueName, String invalidAddress) {
        this.needRefresh.set(this.invalidAddresses.addIfAbsent(invalidAddress));
    }

    public synchronized void removeInvalidAddressesAndRefresh(List<String> needDeleteList) {
        this.needRefresh.set(this.invalidAddresses.removeAll(needDeleteList));
    }

    public synchronized void setAllAddresses(List<String> addresses) {
        this.allAddresses = addresses;
        this.needRefresh.set(true);
        HashMap<String, String> newIp2Addresses = new HashMap<String, String>();
        for (String url : this.allAddresses) {
            newIp2Addresses.put(HSFServiceTargetUtil.getTargetIP((String)url), url);
        }
        this.ip2Addresses = newIp2Addresses;
    }

    public synchronized void setFlowControlRule(FlowControlRule flowControlRule) {
        this.flowControlRule = flowControlRule;
        this.needRefresh.set(true);
    }

    public synchronized void refreshAddress() {
        if (this.needRefresh.compareAndSet(true, false)) {
            this.refreshLocalAddress();
            this.refreshAvailableAddress();
        }
    }

    public synchronized void setRouteRule(RouteRule routeRule) {
        this.routeResultCache.setRouteRule(routeRule);
        this.needRefresh.set(true);
    }

    public String toString() {
        return "AddressBucket [allAddresses=" + this.getAddressesByConfigStyle() + ", invalidAddresses=" + this.invalidAddresses + ", localAddresses=" + this.localAddresses + ", availableAddresses=" + this.availableAddresses + "]";
    }

    private void refreshAvailableAddress() {
        ArrayList<String> addedAddresses;
        String msg = null;
        if (this.flowControlRule == null) {
            this.availableAddresses = this.getAvailableAddresses(this.getAddressesByConfigStyle());
            msg = MessageFormat.format(PATTERN_MSG, this.serviceUniqueName, this.getAddressesByConfigStyle().size(), this.availableAddresses.size(), "off");
        } else {
            List<String> localAvailableAddresses = this.getAvailableAddresses(this.localAddresses);
            if (localAvailableAddresses.size() > 0 && this.flowControlRule.isLocalPreferred(this.getAddressesByConfigStyle().size(), localAvailableAddresses.size())) {
                this.availableAddresses = localAvailableAddresses;
                msg = MessageFormat.format(PATTERN_MSG, this.serviceUniqueName, this.getAddressesByConfigStyle().size(), this.availableAddresses == null ? 0 : this.availableAddresses.size(), "on");
                StringBuilder sb = new StringBuilder(msg);
                if (this.availableAddresses != null) {
                    sb.append(" Available addresses [");
                    for (String address : this.availableAddresses) {
                        sb.append("  >>> ").append(address).append("\n");
                    }
                    sb.append("]");
                }
            } else {
                this.availableAddresses = this.getAvailableAddresses(this.getAddressesByConfigStyle());
                msg = MessageFormat.format(PATTERN_MSG, this.serviceUniqueName, this.getAddressesByConfigStyle().size(), this.availableAddresses.size(), "off");
            }
        }
        if (this.unitName != null) {
            msg = msg + "Unit=" + this.unitName;
        }
        if (this.weightingRule != null) {
            addedAddresses = new ArrayList<String>();
            for (String address : this.availableAddresses) {
                int weight = this.weightingRule.getWeight(address);
                for (int i = 1; i < weight; ++i) {
                    addedAddresses.add(address);
                }
            }
            this.availableAddresses.addAll(addedAddresses);
        } else if (this.rtWeightMap.size() > 0) {
            addedAddresses = new ArrayList();
            for (String remoteIp : this.rtWeightMap.keySet()) {
                Integer weight;
                String address;
                address = this.ip2Addresses.get(remoteIp);
                if (null == address || null == (weight = this.rtWeightMap.get(remoteIp))) continue;
                for (int i = 1; i < weight; ++i) {
                    addedAddresses.add(address);
                }
            }
            this.availableAddresses.addAll(addedAddresses);
        }
        this.routeResultCache.setAllAvailableAddresses(this.availableAddresses);
        this.routeResultCache.reset();
        LOGGER.info(msg);
    }

    private void refreshLocalAddress() {
        List<String> newLocalAddresses;
        if (this.getAddressesByConfigStyle() == null) {
            return;
        }
        if (this.flowControlRule == null) {
            newLocalAddresses = new ArrayList<String>();
            newLocalAddresses.addAll(this.getAddressesByConfigStyle());
        } else {
            GlobalRule globalRule = this.addressPool.getGlobalRule();
            if (globalRule == null || globalRule.getVirtualCmRule() == null) {
                newLocalAddresses = this.flowControlRule.siftLocalAddress(this.getAddressesByConfigStyle());
            } else {
                VirtualCmRule virtualCmRule = globalRule.getVirtualCmRule();
                newLocalAddresses = virtualCmRule.siftLocalAddress(this.getAddressesByConfigStyle());
            }
        }
        this.localAddresses = newLocalAddresses;
    }

    private List<String> getAvailableAddresses(List<String> addresses) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.invalidAddresses.isEmpty()) {
            result.addAll(addresses);
            return result;
        }
        for (String address : addresses) {
            if (this.invalidAddresses.contains(address)) continue;
            result.add(address);
        }
        return result;
    }

    public List<String> getArgsAddresses(String methodName, String[] parameterTypes, Object[] args) {
        return this.routeResultCache.getArgsAddresses(methodName, parameterTypes, args);
    }

    public synchronized void setAllDubboAddresses(List<String> list) {
        ArrayList<String> processedList = new ArrayList<String>();
        if (list != null) {
            for (String address : list) {
                if (address == null) continue;
                if (address.startsWith("dubbo://") && address.length() > 8) {
                    processedList.add(address.substring(8));
                    continue;
                }
                processedList.add(address);
            }
        }
        this.allDubboAddress = processedList;
        this.needRefresh.set(true);
    }

    public synchronized void setWeightRule(WeightingRule weightRule) {
        this.weightingRule = weightRule;
        this.needRefresh.set(true);
    }

    public synchronized void setRtWeightMap(Map<String, Integer> rtWeightMap) {
        this.rtWeightMap = rtWeightMap;
        this.needRefresh.set(true);
    }

    public String getAddressByIp(String ip) {
        return this.ip2Addresses.get(ip);
    }
}

