/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.globalrule;

import com.taobao.hsf.util.InetAddressUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VirtualCmRule {
    private final String RULE_NAME = "VirtualCmRule";
    private List<List<String>> cmGroups = new ArrayList<List<String>>();

    public void addCmGroup(List<String> cmGroup) {
        this.cmGroups.add(cmGroup);
    }

    public List<String> siftLocalAddress(List<String> addresses) {
        try {
            if (addresses == null || addresses.isEmpty()) {
                return new ArrayList<String>();
            }
            String localIp = InetAddressUtil.getIP();
            if (localIp == null) {
                return addresses;
            }
            List<String> cmGroup = this.findCmGroup(localIp);
            if (cmGroup == null) {
                String tmp = StringUtils.substringBeforeLast((String)localIp, (String)".");
                tmp = StringUtils.substringBeforeLast((String)tmp, (String)".");
                cmGroup = new ArrayList<String>();
                cmGroup.add(tmp);
            }
            ArrayList<String> result = new ArrayList<String>();
            for (String address : addresses) {
                if (!this.matchCmGroup(address, cmGroup)) continue;
                result.add(address);
            }
            return result;
        }
        catch (Throwable t) {
            return addresses;
        }
    }

    private List<String> findCmGroup(String ip) {
        for (List<String> cmGroup : this.cmGroups) {
            if (!this.matchCmGroup(ip, cmGroup)) continue;
            return cmGroup;
        }
        return null;
    }

    private boolean matchCmGroup(String target, List<String> cmGroup) {
        if (target != null) {
            for (String regex : cmGroup) {
                if (!target.startsWith(regex)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return "[VirtualCmRule] " + this.cmGroups;
    }

    public String getName() {
        return "VirtualCmRule";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualCmRule other = (VirtualCmRule)obj;
        return !(this.cmGroups == null ? other.cmGroups != null : !((Object)this.cmGroups).equals(other.cmGroups));
    }
}

