/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.route.flowcontrol;

import com.taobao.hsf.rule.Rule;
import com.taobao.hsf.util.InetAddressUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FlowControlRule
implements Rule {
    public static final String FLOWCONTROL = "flowControl";
    public static final String TAG_LOCALPREFERRED = "localPreferredSwitch";
    public static final String TAG_THRESHOLD = "threshold";
    public static final String TAG_EXCLUSIONS = "exclusions";
    public static final String SWITCH_ON = "on";
    public static final String SWITCH_OFF = "off";
    private String localPreferredSwitch = "off";
    private float threshold = 0.0f;

    public String getLocalPreferredSwitch() {
        return this.localPreferredSwitch;
    }

    @Override
    public String getName() {
        return "FlowControlRule";
    }

    @Override
    public String getRawRule() {
        throw new UnsupportedOperationException();
    }

    public float getThreshold() {
        return this.threshold;
    }

    public boolean isLocalPreferred(int allAmount, int localAvailableAmount) {
        if (SWITCH_OFF.equals(this.localPreferredSwitch)) {
            return false;
        }
        if (allAmount == 0) {
            return false;
        }
        float value = ((float)localAvailableAmount + 0.0f) / (float)allAmount;
        return value >= this.threshold;
    }

    public void setLocalPreferredSwitch(String localPreferredSwitch) {
        this.localPreferredSwitch = localPreferredSwitch;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public String toString() {
        return "FlowControlRule [localPreferredSwitch=" + this.localPreferredSwitch + ", threshold=" + this.threshold + "]";
    }

    public List<String> siftLocalAddress(List<String> addresses) {
        String localIp = InetAddressUtil.getIP();
        if (localIp == null || SWITCH_OFF.equals(this.localPreferredSwitch)) {
            return addresses;
        }
        String cmIpPrefix = StringUtils.substringBeforeLast((String)localIp, (String)".");
        cmIpPrefix = StringUtils.substringBeforeLast((String)cmIpPrefix, (String)".");
        ArrayList<String> result = new ArrayList<String>();
        for (String address : addresses) {
            if (!address.startsWith(cmIpPrefix)) continue;
            result.add(address);
        }
        return result;
    }

    @Override
    public boolean validate() {
        return !(this.threshold < 0.0f) && !(this.threshold >= 1.0f);
    }
}

