/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class UniqId {
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Map<Character, Integer> rDigits = new HashMap<Character, Integer>(16);
    private static UniqId me;
    private String hostAddr;
    private Random random = new SecureRandom();
    private MessageDigest mHasher;
    private UniqTimer timer = new UniqTimer();
    private ReentrantLock opLock = new ReentrantLock();

    public static UniqId getInstance() {
        return me;
    }

    private UniqId() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostAddr = addr.getHostAddress();
        }
        catch (IOException e) {
            this.hostAddr = String.valueOf(System.currentTimeMillis());
        }
        if (this.hostAddr == null || "".equals(this.hostAddr.trim()) || "127.0.0.1".equals(this.hostAddr)) {
            this.hostAddr = String.valueOf(System.currentTimeMillis());
        }
        try {
            this.mHasher = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nex) {
            this.mHasher = null;
        }
    }

    public String bytes2string(byte[] bt) {
        int l = bt.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = digits[(0xF0 & bt[i]) >>> 4];
            out[j++] = digits[0xF & bt[i]];
        }
        return new String(out);
    }

    public String getUniqID() {
        StringBuffer sb = new StringBuffer();
        long t = this.timer.getCurrentTime();
        sb.append(t);
        sb.append("-");
        sb.append(this.random.nextInt(8999) + 1000);
        sb.append("-");
        sb.append(this.hostAddr);
        sb.append("-");
        sb.append(Thread.currentThread().hashCode());
        return sb.toString();
    }

    public byte[] getUniqIDHash() {
        return this.hash(this.getUniqID());
    }

    public String getUniqIDHashString() {
        return this.hashString(this.getUniqID());
    }

    public long getUniqTime() {
        return this.timer.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hash(byte[] data) {
        this.opLock.lock();
        try {
            byte[] bt = this.mHasher.digest(data);
            if (null == bt || bt.length != 16) {
                throw new IllegalArgumentException("md5 need");
            }
            byte[] byArray = bt;
            return byArray;
        }
        finally {
            this.opLock.unlock();
        }
    }

    public byte[] hash(String str) {
        this.opLock.lock();
        try {
            byte[] bt = this.mHasher.digest(str.getBytes("UTF-8"));
            if (null == bt || bt.length != 16) {
                throw new IllegalArgumentException("md5 need");
            }
            byte[] byArray = bt;
            return byArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unsupported utf-8 encoding", e);
        }
        finally {
            this.opLock.unlock();
        }
    }

    public String hashBytes(byte[] str) {
        byte[] bt = this.hash(str);
        return this.bytes2string(bt);
    }

    public String hashString(String str) {
        byte[] bt = this.hash(str);
        return this.bytes2string(bt);
    }

    public byte[] string2bytes(String str) {
        if (null == str) {
            throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (str.length() != 32) {
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u957f\u5ea6\u5fc5\u987b\u662f32");
        }
        byte[] data = new byte[16];
        char[] chs = str.toCharArray();
        for (int i = 0; i < 16; ++i) {
            int h = rDigits.get(Character.valueOf(chs[i * 2]));
            int l = rDigits.get(Character.valueOf(chs[i * 2 + 1]));
            data[i] = (byte)((h & 0xF) << 4 | l & 0xF);
        }
        return data;
    }

    static {
        for (int i = 0; i < digits.length; ++i) {
            rDigits.put(Character.valueOf(digits[i]), i);
        }
        me = new UniqId();
    }

    private static class UniqTimer {
        private AtomicLong lastTime = new AtomicLong(System.currentTimeMillis());

        private UniqTimer() {
        }

        public long getCurrentTime() {
            return this.lastTime.incrementAndGet();
        }
    }
}

