/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.weighting;

import com.taobao.hsf.rule.Rule;
import com.taobao.hsf.weighting.WeightingRuleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class WeightingRule
implements Rule {
    private final List<WeightingRuleItem> items = new ArrayList<WeightingRuleItem>();
    private long expireTime = System.currentTimeMillis() + 3600000L;
    private final String rawRule;

    public WeightingRule(String rawRule) {
        this.rawRule = rawRule;
    }

    public void addItem(WeightingRuleItem item) {
        this.items.add(item);
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public List<WeightingRuleItem> getItems() {
        return this.items;
    }

    @Override
    public String getName() {
        return "WeightingRule";
    }

    @Override
    public String getRawRule() {
        return this.rawRule;
    }

    @Override
    public boolean validate() {
        return true;
    }

    public int getWeight(String ip) {
        if (this.getExpireTime() > System.currentTimeMillis()) {
            for (WeightingRuleItem rule : this.items) {
                for (Pattern ipPattern : rule.getIpPatterns()) {
                    if (!ipPattern.matcher(ip).find()) continue;
                    return rule.getWeight();
                }
            }
        }
        return 1;
    }
}

