/*
 * (C) 2007-2012 Alibaba Group Holding Limited.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * Authors:
 *   boyan <killme2008@gmail.com>
 */
package com.taobao.common.store.journal;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import com.taobao.common.store.util.BytesKey;


/**
 * 
 * 
 * Map
 * 
 * @author boyan
 * 
 * @since 1.0, 2009-10-20 10:49:42
 */

public interface IndexMap {
    public void put(BytesKey key, OpItem opItem);


    public void remove(BytesKey key);


    public OpItem get(BytesKey key);


    public int size();


    public boolean containsKey(BytesKey key);


    public Iterator<BytesKey> keyIterator();


    public void putAll(Map<BytesKey, OpItem> map);


    public void close() throws IOException;
}