/*
 * (C) 2007-2012 Alibaba Group Holding Limited.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * Authors:
 *   dogun (yuexuqiang at gmail.com)
 */
package com.taobao.common.store.journal;

import java.io.IOException;


/**
 * ־ʽ洢MBean
 * 
 * @author dogun (yuexuqiang at gmail.com)
 */
public interface JournalStoreMBean {

    /**
     * ЧļϢ
     * 
     * @return ЧļϢ
     */
    String getDataFilesInfo();


    /**
     * Ч־ļϢ
     * 
     * @return Ч־ļϢ
     */
    String getLogFilesInfo();


    /**
     * ȡǰļ
     * 
     * @return ǰļ
     */
    int getNumber();


    /**
     * ȡ洢·
     * 
     * @return the path
     */
    String getPath();


    /**
     * ȡ洢
     * 
     * @return the name
     */
    String getName();


    /**
     * ȡǰļϢ
     * 
     * @return ǰļϢ
     */
    String getDataFileInfo();


    /**
     * ȡǰ־ļϢ
     * 
     * @return ǰ־ļϢ
     */
    String getLogFileInfo();


    /**
     * 鿴Ϣ<b>ע:</b>òܻűڴ
     * 
     * @return еϢ
     */
    String viewIndexMap();


    /**
     * ݵĸ
     * 
     * @return ݵĸ
     * @throws IOException
     */
    long getSize() throws IOException;


    /**
     * ļм飬ӦĴ
     * 
     * @throws IOException
     */
    void check() throws IOException;


    long getIntervalForRemove();


    void setIntervalForRemove(long interval);


    long getIntervalForCompact();


    void setIntervalForCompact(long interval);
}