/*
 * (C) 2007-2012 Alibaba Group Holding Limited.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * Authors:
 *   wuhua <wq163@163.com> , boyan <killme2008@gmail.com>
 */
package com.taobao.metamorphosis.consumer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;

import com.taobao.metamorphosis.Message;
import com.taobao.metamorphosis.exception.InvalidMessageException;
import com.taobao.metamorphosis.utils.MessageUtils;


/**
 * Ϣ
 * 
 * @author boyan
 * @Date 2011-4-20
 * 
 */
public class MessageIterator {
    private final String topic;
    private final byte[] data;
    private int offset;
    private Message message;
    private ByteBuffer currentMsgBuf;


    public MessageIterator(final String topic, final byte[] data) {
        super();
        this.topic = topic;
        this.data = data;
        this.offset = 0;
    }


    public ByteBuffer getCurrentMsgBuf() {
        return this.currentMsgBuf;
    }


    public int getDataLength() {
        return this.data != null ? this.data.length : 0;
    }


    public void setOffset(final int offset) {
        this.offset = offset;
    }


    public Message getPrevMessage() {
        return this.message;
    }


    /**
     * صǰƫƫ
     * 
     * @return
     */
    public int getOffset() {
        return this.offset;
    }


    /**
     * Ϣʱ򷵻true
     * 
     * @return
     */
    public boolean hasNext() {
        if (this.data == null || this.data.length == 0) {
            return false;
        }
        if (this.offset >= this.data.length) {
            return false;
        }
        if (this.data.length - this.offset < MessageUtils.HEADER_LEN) {
            return false;
        }
        final int msgLen = MessageUtils.getInt(this.offset, this.data);
        if (this.data.length - this.offset - MessageUtils.HEADER_LEN < msgLen) {
            return false;
        }
        return true;

    }


    /**
     * һϢ
     * 
     * @return
     * @throws InvalidMessageException
     */
    public Message next() throws InvalidMessageException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        final MessageUtils.DecodedMessage decodeMessage =
                MessageUtils.decodeMessage(this.topic, this.data, this.offset);
        this.setOffset(decodeMessage.newOffset);
        this.message = decodeMessage.message;
        this.currentMsgBuf = decodeMessage.buf;
        return decodeMessage.message;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.data);
        result = prime * result + this.offset;
        result = prime * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }


    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        final MessageIterator other = (MessageIterator) obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.topic == null) {
            if (other.topic != null) {
                return false;
            }
        }
        else if (!this.topic.equals(other.topic)) {
            return false;
        }
        return true;
    }


    public void remove() {
        throw new UnsupportedOperationException("Unsupported remove");

    }

}