/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.message;

import com.taobao.notify.common.config.MessageProperties;
import com.taobao.notify.message.Message;
import com.taobao.notify.message.MessageConverter;
import java.util.Arrays;

public class BytesMessage
extends Message {
    private static final long serialVersionUID = 5245159546236462792L;
    private byte[] body;

    public BytesMessage() {
        this.setConcreteType(Message.MessageClassType.BytesMessage);
        this.setOriginType(Message.MessageClassType.BytesMessage);
    }

    public BytesMessage(byte[] msgId) {
        this.setMessageId(msgId);
        this.setConcreteType(Message.MessageClassType.BytesMessage);
        this.setOriginType(Message.MessageClassType.BytesMessage);
    }

    @Override
    public Message innerToProcessType() {
        switch (this.getOriginType()) {
            case StringMessage: {
                return MessageConverter.toStringMessage(this);
            }
            case StreamMessage: {
                return MessageConverter.toSteamMessage(this);
            }
            case ObjectMessage: {
                return MessageConverter.toObjectMessage(this);
            }
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.body);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BytesMessage other = (BytesMessage)obj;
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Message innerToSendType(MessageProperties properties) {
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }
}

