/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.message;

import com.alibaba.common.lang.SystemUtil;
import com.taobao.notify.common.config.MessageProperties;
import com.taobao.notify.message.BytesMessage;
import com.taobao.notify.message.MessageConverter;
import com.taobao.notify.tools.FlagTranslator;
import com.taobao.notify.tools.StringTools;
import com.taobao.notify.utils.UniqId;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Message
implements Serializable {
    private static final long serialVersionUID = -8548915719716251362L;
    public static final String ENTRY_SPLIT = "\u0001";
    public static final String KEY_VALUE_SPLIT = "\u0002";
    private boolean committed;
    private byte[] messageId = null;
    private String groupId;
    private String topic;
    private String messageType;
    private long GMTCreate;
    private long GMTLastDelivery;
    private short deliveryCount;
    private int timeToLive;
    private int dlqTime;
    private String publisherHostName;
    private long bornTime;
    private int postTimeout;
    private transient int clientPostTimeout = 3000;
    private int version = 1;
    private int priority = 5;
    private int flag;
    private long postDelayTime;
    Map<String, String> userDefinedProperties = new HashMap<String, String>();
    private String targetGroup;
    private String replyToTopic;
    private long replyId = 0L;
    private String replyToMessageType;
    private String[] replyWhenDeliveredGroups;

    public Message() {
        this.setGMTCreate(-1L);
        this.setGMTLastDelivery(-1L);
        this.setDeliveryCount((short)-1);
        this.setTimeToLive(-1);
        this.setDLQTime(-1);
        this.setPostTimeout(-1);
        this.setSendOnceMessage(false);
        this.initPublisherHostName();
        this.setPostDelayTime(-1L);
        this.setCharset(Charset.GBKCharset);
        this.setCompressMode(CompressMode.NoneCompress);
        this.setBornTime(System.currentTimeMillis());
    }

    void copyPropertiesFrom(Message message) {
        byte[] msgId = new byte[message.getMessageId().length];
        System.arraycopy(message.getMessageId(), 0, msgId, 0, msgId.length);
        this.setMessageId(msgId);
        this.setGroupId(message.groupId);
        this.setTopic(message.getTopic());
        this.setMessageType(message.getMessageType());
        this.setCommitted(message.isCommitted());
        this.setPostDelayTime(message.getPostDelayTime());
        this.setGMTCreate(message.getGMTCreate());
        this.setGMTLastDelivery(message.getGMTLastDelivery());
        this.setDeliveryCount(message.getDeliverCount());
        this.setTimeToLive(message.getTimeToLive());
        this.setDLQTime(message.getDLQTime());
        this.setSendOnceMessage(message.isSendOnceMessage());
        this.setPublisherHostName(message.getPublisherHostName());
        this.setConcreteType(message.getConcreteType());
        this.setCompressMode(message.getCompressMode());
        this.setOriginType(message.getOriginType());
        this.setCharset(message.getCharset());
        this.setBornTime(message.getBornTime());
        this.setPostTimeout(message.getPostTimeout());
        this.setUserDefinedProperties(message.getProperties());
        this.setClientPostTimeout(message.getClientPostTimeout());
        this.setPriority(message.getPriority());
        this.setReplyId(message.getReplyId());
        this.setReplyToTopic(message.getReplyToTopic());
        this.setReplyToMessageType(message.getReplyToMessageType());
        this.setReplyWhenDeliveredGroups(message.getReplyWhenDeliveredGroups());
    }

    public String getTargetGroup() {
        return this.targetGroup;
    }

    public String getReplyToTopic() {
        return this.replyToTopic;
    }

    public String getReplyToMessageType() {
        return this.replyToMessageType;
    }

    void setReplyToTopic(String replyToTopic) {
        this.replyToTopic = replyToTopic;
    }

    void setReplyToMessageType(String replyToMessageType) {
        this.replyToMessageType = replyToMessageType;
    }

    void setReplyWhenDeliveredGroups(String[] replyWhenDeliveredGroups) {
        this.replyWhenDeliveredGroups = replyWhenDeliveredGroups;
    }

    public long getReplyId() {
        return this.replyId;
    }

    void setReplyId(long replyId) {
        this.replyId = replyId;
    }

    public void replyWhenDeliverd(String groupId, String ... otherGroups) {
        if (groupId == null) {
            throw new IllegalArgumentException("groupId\u4e0d\u53ef\u4e3anull");
        }
        if (otherGroups != null) {
            for (String arg : otherGroups) {
                if (arg != null) continue;
                throw new IllegalArgumentException("groupId\u4e0d\u53ef\u4e3anull");
            }
        }
        HashSet<String> set = new HashSet<String>();
        set.add(groupId);
        for (String arg : otherGroups) {
            set.add(arg);
        }
        this.replyWhenDeliveredGroups = set.toArray(new String[set.size()]);
    }

    String[] getReplyWhenDeliveredGroups() {
        return this.replyWhenDeliveredGroups;
    }

    public long getPostDelayTime() {
        return this.postDelayTime;
    }

    public void setPostDelayTime(long postDelayTime) {
        this.postDelayTime = postDelayTime;
    }

    void setTargetGroup(String targetGroup) {
        this.targetGroup = targetGroup;
    }

    public byte[] getMessageId() {
        return this.messageId;
    }

    public void setMessageId(byte[] messageId) {
        this.messageId = messageId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        if (StringTools.containsWhitespace(topic)) {
            throw new IllegalArgumentException("topic\u4e0d\u80fd\u5305\u542b\u7a7a\u767d\u5b57\u7b26");
        }
        this.topic = topic;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        if (StringTools.containsWhitespace(groupId)) {
            throw new IllegalArgumentException("groupId\u4e0d\u80fd\u5305\u542b\u7a7a\u767d\u5b57\u7b26");
        }
        this.groupId = groupId;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        if (StringTools.containsWhitespace(messageType)) {
            throw new IllegalArgumentException("messageType\u4e0d\u80fd\u5305\u542b\u7a7a\u767d\u5b57\u7b26");
        }
        this.messageType = messageType;
    }

    public long getGMTCreate() {
        return this.GMTCreate;
    }

    void setGMTCreate(long GMTCreate) {
        this.GMTCreate = GMTCreate;
    }

    public long getGMTLastDelivery() {
        return this.GMTLastDelivery;
    }

    void setGMTLastDelivery(long GMTLastDelivery) {
        this.GMTLastDelivery = GMTLastDelivery;
    }

    public short getDeliverCount() {
        return this.deliveryCount;
    }

    void setDeliveryCount(short deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    protected void check(String value) {
        if (-1 != value.indexOf(ENTRY_SPLIT) || -1 != value.indexOf(KEY_VALUE_SPLIT)) {
            throw new IllegalArgumentException("Message\u7684properties\u4e0d\u80fd\u5305\u542b'(char)1' \u6216 '(char)2'\u7279\u6b8a\u5b57\u7b26");
        }
    }

    MessageClassType getConcreteType() {
        return FlagTranslator.getConcreteType(this.flag);
    }

    void setConcreteType(MessageClassType type) {
        this.flag = FlagTranslator.setBackConcreteType(this.flag, type);
    }

    MessageClassType getOriginType() {
        return FlagTranslator.getOriginType(this.flag);
    }

    void setOriginType(MessageClassType type) {
        this.flag = FlagTranslator.setBackOriginType(this.flag, type);
    }

    CompressMode getCompressMode() {
        return FlagTranslator.getCompressMode(this.flag);
    }

    void setCompressMode(CompressMode mode) {
        this.flag = FlagTranslator.setBackCompressMode(this.flag, mode);
    }

    public Charset getCharset() {
        return FlagTranslator.getCharset(this.flag);
    }

    public void setCharset(Charset charset) {
        this.flag = FlagTranslator.setBackCharset(this.flag, charset);
    }

    public boolean isSendOnceMessage() {
        return FlagTranslator.isSendOnceMessage(this.flag);
    }

    public void setSendOnceMessage(boolean sendOnceMessage) {
        this.flag = FlagTranslator.setBackSendOnceMessage(this.flag, sendOnceMessage);
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getDLQTime() {
        return this.dlqTime;
    }

    public void setDLQTime(int dlqTime) {
        this.dlqTime = dlqTime;
    }

    public String getPublisherHostName() {
        return this.publisherHostName;
    }

    public void setPublisherHostName(String publisherHostName) {
        this.publisherHostName = publisherHostName;
    }

    private void initPublisherHostName() {
        this.publisherHostName = SystemUtil.getHostInfo().getName();
    }

    public String toStringWithoutBody() {
        return "\tid:" + UniqId.getInstance().bytes2string(this.getMessageId()) + "\n" + "\tType:" + this.getMessageType() + "\n" + "\ttopic:" + this.getTopic() + "\n" + "\tgroupId:" + this.getGroupId() + "\n";
    }

    public String toExtStringWithoutBody() {
        return this.toStringWithoutBody() + "\tConcreteType: " + this.getConcreteType().toString() + "\tCompress: " + (Object)((Object)this.getCompressMode()) + "\n" + "\tSendOnceMessage: " + this.isSendOnceMessage() + "\n" + "\tHostName: " + this.getPublisherHostName() + "\n";
    }

    public String toFullStringWithoutBody() {
        return this.toExtStringWithoutBody() + "\tGMTCreate: " + StringTools.long2TimeString(this.getGMTCreate()) + "\n" + "\tGMTLastDeliver: " + StringTools.long2TimeString(this.getGMTLastDelivery()) + "\n" + "\tDeliverCount: " + this.getDeliverCount() + "\n" + "\tTimeToLive: " + this.getTimeToLive() + "\n" + "\tDLQTime: " + this.getDLQTime() + "\n" + "\tOutOfTime:" + this.getPostTimeout() + "\n" + "\tPriority:" + this.getPriority() + "\n" + "\tPostDelayTime:" + this.getPostDelayTime() + "\n";
    }

    public byte getByteProperty(String property) throws Exception {
        String value = this.userDefinedProperties.get(property);
        if (null == value) {
            throw new Exception("\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u8be5\u5c5e\u6027\uff1a" + property);
        }
        return Byte.parseByte(value);
    }

    public short getShortProperty(String property) throws Exception {
        String value = this.userDefinedProperties.get(property);
        if (null == value) {
            throw new Exception("\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u8be5\u5c5e\u6027\uff1a" + property);
        }
        return Short.parseShort(value);
    }

    public int getIntProperty(String property) throws Exception {
        String value = this.userDefinedProperties.get(property);
        if (null == value) {
            throw new Exception("\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u8be5\u5c5e\u6027\uff1a" + property);
        }
        return Integer.parseInt(value);
    }

    public long getLongProperty(String property) throws Exception {
        String value = this.userDefinedProperties.get(property);
        if (null == value) {
            throw new Exception("\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u8be5\u5c5e\u6027\uff1a" + property);
        }
        return Long.parseLong(value);
    }

    public float getFloatProperty(String property) throws Exception {
        String value = this.userDefinedProperties.get(property);
        if (null == value) {
            throw new Exception("\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u8be5\u5c5e\u6027\uff1a" + property);
        }
        return Float.parseFloat(value);
    }

    public double getDoubleProperty(String property) throws Exception {
        String value = this.userDefinedProperties.get(property);
        if (null == value) {
            throw new Exception("\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u8be5\u5c5e\u6027\uff1a" + property);
        }
        return Double.parseDouble(value);
    }

    public boolean getBooleanProperty(String property) throws Exception {
        String value = this.userDefinedProperties.get(property);
        if (null == value) {
            throw new Exception("\u7528\u6237\u6ca1\u6709\u8bbe\u7f6e\u8be5\u5c5e\u6027\uff1a" + property);
        }
        return Boolean.parseBoolean(value);
    }

    public String getStringProperty(String property) throws Exception {
        return this.userDefinedProperties.get(property);
    }

    public void setByteProperty(String property, byte value) {
        this.check(property);
        this.userDefinedProperties.put(property, String.valueOf(value));
    }

    public void setShortProperty(String property, short value) {
        this.check(property);
        this.userDefinedProperties.put(property, String.valueOf(value));
    }

    public void setIntProperty(String property, int value) {
        this.check(property);
        this.userDefinedProperties.put(property, String.valueOf(value));
    }

    public void setLongProperty(String property, long value) {
        this.check(property);
        this.userDefinedProperties.put(property, String.valueOf(value));
    }

    public void setFloatProperty(String property, float value) {
        this.check(property);
        this.userDefinedProperties.put(property, String.valueOf(value));
    }

    public void setDoubleProperty(String property, double value) {
        this.check(property);
        this.userDefinedProperties.put(property, String.valueOf(value));
    }

    public void setBooleanProperty(String property, boolean value) {
        this.check(property);
        this.userDefinedProperties.put(property, String.valueOf(value));
    }

    public void setStringProperty(String property, String value) {
        this.check(property);
        this.check(value);
        this.userDefinedProperties.put(property, value);
    }

    public boolean propertyExists(String property) {
        return this.userDefinedProperties.containsKey(property);
    }

    public Set<String> getPropertyNames() {
        return this.userDefinedProperties.keySet();
    }

    public int getFlag() {
        return this.flag;
    }

    void setFlag(int flag) {
        this.flag = flag;
    }

    public Map<String, String> getProperties() {
        return this.userDefinedProperties;
    }

    public void clearProperties() {
        this.userDefinedProperties.clear();
    }

    void setUserDefinedProperties(Map<String, String> userDefinedProperties) {
        this.userDefinedProperties.clear();
        if (userDefinedProperties != null) {
            this.userDefinedProperties.putAll(userDefinedProperties);
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public long getBornTime() {
        return this.bornTime;
    }

    void setBornTime(long bornTime) {
        this.bornTime = bornTime;
    }

    public int getPostTimeout() {
        return this.postTimeout;
    }

    public void setPostTimeout(int postTimeout) {
        this.postTimeout = postTimeout;
    }

    public int getClientPostTimeout() {
        return this.clientPostTimeout;
    }

    public void setClientPostTimeout(int clientPostTimeout) {
        this.clientPostTimeout = clientPostTimeout;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("\u6d88\u606f\u4f18\u5148\u7ea7\u7684\u53d6\u503c\u5fc5\u987b\u662f1 - 10\u4e4b\u95f4.");
        }
        this.priority = priority;
    }

    public int getVersion() {
        return this.version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public Message toSendType(MessageProperties properties) {
        BytesMessage bytesMsgResult;
        Message msg;
        if (null == this.getMessageId()) {
            this.setMessageId(UniqId.getInstance().getUniqIDHash());
        }
        if ((msg = this.innerToSendType(properties)) instanceof BytesMessage && (bytesMsgResult = (BytesMessage)msg).getBody().length >= properties.getCompressSize()) {
            return MessageConverter.compress(bytesMsgResult);
        }
        return msg;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.GMTCreate ^ this.GMTCreate >>> 32);
        result = 31 * result + (int)(this.GMTLastDelivery ^ this.GMTLastDelivery >>> 32);
        result = 31 * result + (int)(this.bornTime ^ this.bornTime >>> 32);
        result = 31 * result + (this.committed ? 1231 : 1237);
        result = 31 * result + this.deliveryCount;
        result = 31 * result + this.dlqTime;
        result = 31 * result + this.flag;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + Arrays.hashCode(this.messageId);
        result = 31 * result + (this.messageType == null ? 0 : this.messageType.hashCode());
        result = 31 * result + (int)(this.postDelayTime ^ this.postDelayTime >>> 32);
        result = 31 * result + this.postTimeout;
        result = 31 * result + this.priority;
        result = 31 * result + (this.publisherHostName == null ? 0 : this.publisherHostName.hashCode());
        result = 31 * result + (int)(this.replyId ^ this.replyId >>> 32);
        result = 31 * result + (this.replyToMessageType == null ? 0 : this.replyToMessageType.hashCode());
        result = 31 * result + (this.replyToTopic == null ? 0 : this.replyToTopic.hashCode());
        result = 31 * result + Arrays.hashCode(this.replyWhenDeliveredGroups);
        result = 31 * result + (this.targetGroup == null ? 0 : this.targetGroup.hashCode());
        result = 31 * result + this.timeToLive;
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        result = 31 * result + (this.userDefinedProperties == null ? 0 : ((Object)this.userDefinedProperties).hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (this.GMTCreate != other.GMTCreate) {
            return false;
        }
        if (this.GMTLastDelivery != other.GMTLastDelivery) {
            return false;
        }
        if (this.bornTime != other.bornTime) {
            return false;
        }
        if (this.committed != other.committed) {
            return false;
        }
        if (this.deliveryCount != other.deliveryCount) {
            return false;
        }
        if (this.dlqTime != other.dlqTime) {
            return false;
        }
        if (this.flag != other.flag) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (!Arrays.equals(this.messageId, other.messageId)) {
            return false;
        }
        if (this.messageType == null ? other.messageType != null : !this.messageType.equals(other.messageType)) {
            return false;
        }
        if (this.postDelayTime != other.postDelayTime) {
            return false;
        }
        if (this.postTimeout != other.postTimeout) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.publisherHostName == null ? other.publisherHostName != null : !this.publisherHostName.equals(other.publisherHostName)) {
            return false;
        }
        if (this.replyId != other.replyId) {
            return false;
        }
        if (this.replyToMessageType == null ? other.replyToMessageType != null : !this.replyToMessageType.equals(other.replyToMessageType)) {
            return false;
        }
        if (this.replyToTopic == null ? other.replyToTopic != null : !this.replyToTopic.equals(other.replyToTopic)) {
            return false;
        }
        if (!Arrays.equals(this.replyWhenDeliveredGroups, other.replyWhenDeliveredGroups)) {
            return false;
        }
        if (this.targetGroup == null ? other.targetGroup != null : !this.targetGroup.equals(other.targetGroup)) {
            return false;
        }
        if (this.timeToLive != other.timeToLive) {
            return false;
        }
        if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
            return false;
        }
        if (this.userDefinedProperties == null ? other.userDefinedProperties != null : !Message.isDefinedPropertiesEquals(this.userDefinedProperties, other.userDefinedProperties)) {
            return false;
        }
        return this.version == other.version;
    }

    private static <K, V> boolean isDefinedPropertiesEquals(Map<K, V> currProperties, Map<K, V> otherProperties) {
        if (currProperties.size() != otherProperties.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : currProperties.entrySet()) {
            if (otherProperties.containsKey(entry.getKey()) && otherProperties.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public Message toProcessType() {
        if (this instanceof BytesMessage && this.getCompressMode() != CompressMode.NoneCompress) {
            MessageConverter.uncompress((BytesMessage)this);
        }
        return this.innerToProcessType();
    }

    public abstract Message innerToSendType(MessageProperties var1);

    public abstract Message innerToProcessType();

    public static enum CompressMode {
        NoneCompress,
        ZLIBCompress;


        public String toString() {
            switch (this) {
                case NoneCompress: {
                    return "NoneCompress";
                }
                case ZLIBCompress: {
                    return "ZLIBCompress";
                }
            }
            return "Unknown type!";
        }

        public byte toByte() {
            switch (this) {
                case NoneCompress: {
                    return 0;
                }
                case ZLIBCompress: {
                    return 1;
                }
            }
            throw new IllegalArgumentException("Wrong argument: NoneCompress, ZLIBCompress.");
        }

        public static CompressMode parseByte(byte type) {
            switch (type) {
                case 0: {
                    return NoneCompress;
                }
                case 1: {
                    return ZLIBCompress;
                }
            }
            throw new IllegalArgumentException("Wrong argument: 0--NoneCompress, 1--ZLIBCompress.");
        }
    }

    public static enum Charset {
        GBKCharset,
        UTF8Charset;


        public String toString() {
            switch (this) {
                case GBKCharset: {
                    return "GBK";
                }
                case UTF8Charset: {
                    return "utf-8";
                }
            }
            return "Unknown type!";
        }

        public byte toByte() {
            switch (this) {
                case GBKCharset: {
                    return 0;
                }
                case UTF8Charset: {
                    return 1;
                }
            }
            throw new IllegalArgumentException("Wrong argument: \u73b0\u5728\u53ea\u652f\u6301GBKCharset.\u548cUTF8Charset");
        }

        public static Charset parseByte(byte type) {
            switch (type) {
                case 0: {
                    return GBKCharset;
                }
                case 1: {
                    return UTF8Charset;
                }
            }
            throw new IllegalArgumentException("Wrong argument: 0--GBKCharset.1--UTF8Charset");
        }
    }

    public static enum MessageClassType {
        StringMessage,
        BytesMessage,
        PackagedMessage,
        StreamMessage,
        ObjectMessage;


        public String toString() {
            switch (this) {
                case StringMessage: {
                    return "StringMessage";
                }
                case BytesMessage: {
                    return "BytesMessage";
                }
                case PackagedMessage: {
                    return "PackagedMessage";
                }
                case StreamMessage: {
                    return "StreamMessage";
                }
                case ObjectMessage: {
                    return "ObjectMessage";
                }
            }
            return "Unknown type!";
        }

        public byte toByte() {
            switch (this) {
                case StringMessage: {
                    return 0;
                }
                case BytesMessage: {
                    return 1;
                }
                case PackagedMessage: {
                    return 1;
                }
                case ObjectMessage: {
                    return 2;
                }
                case StreamMessage: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Wrong argument: \u73b0\u5728\u53ea\u652f\u6301BytesMessage\uff0cStringMessage\uff0cPackagedMessage");
        }

        public static MessageClassType parseByte(byte type) {
            switch (type) {
                case 0: {
                    return StringMessage;
                }
                case 1: {
                    return BytesMessage;
                }
            }
            throw new IllegalArgumentException("Wrong argument: 0--StringMessage, 1--BytesMessage, 2--PackagedMessage");
        }
    }
}

