/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.message;

import com.taobao.notify.client.exception.NotifyClientCodecException;
import com.taobao.notify.message.BytesMessage;
import com.taobao.notify.message.Message;
import com.taobao.notify.message.ObjectMessage;
import com.taobao.notify.message.PackagedMessage;
import com.taobao.notify.message.StreamMessage;
import com.taobao.notify.message.StringMessage;
import com.taobao.notify.tools.StringTools;
import com.taobao.notify.utils.LoggerPrefix;
import com.taobao.notify.utils.UniqId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.log4j.Logger;

public final class MessageConverter {
    private static final Logger logger = Logger.getLogger(MessageConverter.class);
    private static final String LogPrefix = LoggerPrefix.makeLogPrefix(MessageConverter.class);

    static BytesMessage compress(BytesMessage message) {
        return MessageConverter.compress(message, Message.CompressMode.ZLIBCompress);
    }

    private static BytesMessage compress(BytesMessage message, Message.CompressMode mode) {
        boolean compressed = false;
        if (mode == Message.CompressMode.ZLIBCompress) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(message.getBody().length);
            DeflaterOutputStream os = new DeflaterOutputStream(baos);
            try {
                os.write(message.getBody());
                os.finish();
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.warn((Object)(LogPrefix + "\u538b\u7f29\u65f6\uff0cIOException"), (Throwable)e);
                }
                message.setBody(baos.toByteArray());
                compressed = true;
            }
            catch (IOException e) {
                logger.warn((Object)(LogPrefix + "\u538b\u7f29\u65f6\uff0cIOException"), (Throwable)e);
                throw new RuntimeException(LogPrefix + "\u538b\u7f29\u65f6\uff0cIOException", e);
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
        logger.warn((Object)(LogPrefix + "\u73b0\u5728\u8fd8\u53ea\u652f\u6301ZLIBCompress\u538b\u7f29\u6a21\u5f0f"));
        if (compressed) {
            message.setCompressMode(Message.CompressMode.ZLIBCompress);
        }
        return message;
    }

    static BytesMessage uncompress(BytesMessage message) {
        boolean uncompressed = false;
        int COMPRESS_RATIO = 8;
        if (message.getCompressMode() == Message.CompressMode.NoneCompress) {
            return message;
        }
        if (message.getBody() == null) {
            return message;
        }
        int size = message.getBody().length * COMPRESS_RATIO;
        if (message.getCompressMode() == Message.CompressMode.ZLIBCompress) {
            ByteArrayInputStream bais = new ByteArrayInputStream(message.getBody());
            InflaterInputStream is = new InflaterInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
            try {
                int len;
                byte[] uncompressMessage = new byte[size];
                while ((len = is.read(uncompressMessage)) > 0) {
                    baos.write(uncompressMessage, 0, len);
                }
                baos.flush();
                message.setBody(baos.toByteArray());
                uncompressed = true;
            }
            catch (IOException e) {
                logger.warn((Object)(LogPrefix + "\u89e3\u538b\u7f29\u65f6\uff0cIOException"), (Throwable)e);
                throw new RuntimeException(LogPrefix + "\u89e3\u538b\u7f29\u65f6\uff0cIOException", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                try {
                    bais.close();
                }
                catch (IOException e) {}
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
        logger.warn((Object)(LogPrefix + "\u53ea\u652f\u6301ZLIBCompress\u538b\u7f29\u6a21\u5f0f\u7684\u89e3\u538b\u7f29"));
        if (uncompressed) {
            message.setCompressMode(Message.CompressMode.NoneCompress);
        }
        return message;
    }

    static Message toStringMessage(BytesMessage fromMessage) {
        StringMessage result = new StringMessage(UniqId.getInstance().getUniqIDHash());
        result.copyPropertiesFrom(fromMessage);
        result.setConcreteType(Message.MessageClassType.StringMessage);
        result.setOriginType(Message.MessageClassType.StringMessage);
        result.setBody(StringTools.bytes2String(fromMessage.getBody(), fromMessage.getCharset().toString()));
        return result;
    }

    static BytesMessage toBytesMessage(StringMessage fromMessage) {
        BytesMessage result = new BytesMessage(UniqId.getInstance().getUniqIDHash());
        result.copyPropertiesFrom(fromMessage);
        result.setConcreteType(Message.MessageClassType.BytesMessage);
        result.setOriginType(Message.MessageClassType.StringMessage);
        result.setBody(StringTools.string2Bytes(fromMessage.getBody(), fromMessage.getCharset().toString()));
        return result;
    }

    static Message toSteamMessage(BytesMessage fromMessage) {
        StreamMessage result = new StreamMessage(fromMessage.getMessageId());
        result.setWritable(false);
        result.setReadable(true);
        result.copyPropertiesFrom(fromMessage);
        result.setConcreteType(Message.MessageClassType.BytesMessage);
        result.setOriginType(Message.MessageClassType.StreamMessage);
        result.setBuffer(ByteBuffer.wrap(fromMessage.getBody()));
        return result;
    }

    public static Message toSendTypeMessage(Message fromMessage) {
        if (fromMessage instanceof StreamMessage) {
            ((StreamMessage)fromMessage).setWritable(true);
            ((StreamMessage)fromMessage).setReadable(false);
            ByteBuffer byteBuffer = ((StreamMessage)fromMessage).getByteBuffer();
            byteBuffer.position(byteBuffer.limit());
        } else if (fromMessage instanceof PackagedMessage) {
            List<Message> messageList = ((PackagedMessage)fromMessage).getMessageList();
            for (Message subMessage : messageList) {
                MessageConverter.toSendTypeMessage(subMessage);
            }
        }
        return fromMessage;
    }

    static Message toObjectMessage(BytesMessage fromMessage) {
        ObjectMessage result = new ObjectMessage(fromMessage.getMessageId());
        result.copyPropertiesFrom(fromMessage);
        result.setConcreteType(Message.MessageClassType.BytesMessage);
        result.setOriginType(Message.MessageClassType.ObjectMessage);
        result.setObject(MessageConverter.decodeObject(fromMessage.getBody()));
        return result;
    }

    private static Object decodeObject(byte[] objContent) {
        Object obj = null;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(objContent);
            ois = new ObjectInputStream(bais);
            obj = ois.readObject();
        }
        catch (IOException ex) {
            logger.warn((Object)"Failed to decode object.", (Throwable)ex);
            throw new NotifyClientCodecException(ex);
        }
        catch (ClassNotFoundException ex) {
            logger.warn((Object)"Failed to decode object.", (Throwable)ex);
            throw new NotifyClientCodecException(ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                    bais.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"Failed to close stream.", (Throwable)ex);
                }
            }
        }
        return obj;
    }

    public static final Message toBytesMessage(StreamMessage fromMessage) {
        BytesMessage result = new BytesMessage(UniqId.getInstance().getUniqIDHash());
        result.copyPropertiesFrom(fromMessage);
        result.setConcreteType(Message.MessageClassType.BytesMessage);
        result.setOriginType(Message.MessageClassType.StreamMessage);
        fromMessage.getByteBuffer().flip();
        fromMessage.getByteBuffer().mark();
        byte[] body = new byte[fromMessage.getByteBuffer().remaining()];
        fromMessage.getByteBuffer().get(body);
        result.setBody(body);
        fromMessage.getByteBuffer().reset();
        return result;
    }

    private static byte[] encodeObject(Object objContent) {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream output = null;
        try {
            baos = new ByteArrayOutputStream(1024);
            output = new ObjectOutputStream(baos);
            output.writeObject(objContent);
        }
        catch (IOException ex) {
            throw new NotifyClientCodecException(ex);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (IOException ex) {
                    throw new NotifyClientCodecException(ex);
                }
            }
        }
        return baos.toByteArray();
    }

    public static final Message toBytesMessage(ObjectMessage fromMessage) {
        byte[] body;
        BytesMessage result = new BytesMessage(UniqId.getInstance().getUniqIDHash());
        result.copyPropertiesFrom(fromMessage);
        result.setConcreteType(Message.MessageClassType.BytesMessage);
        result.setOriginType(Message.MessageClassType.ObjectMessage);
        if (null == fromMessage.getObject()) {
            fromMessage.setObject(new byte[0]);
        }
        if ((body = MessageConverter.encodeObject(fromMessage.getObject())) == null) {
            body = new byte[]{};
        }
        result.setBody(body);
        return result;
    }
}

