/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.message;

import com.taobao.notify.client.exception.NotifyClientException;
import com.taobao.notify.client.exception.NotifyClientIllegalArgumentException;
import com.taobao.notify.common.config.MessageProperties;
import com.taobao.notify.message.Message;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class PackagedMessage
extends Message {
    private static final long serialVersionUID = 4790311077177507857L;
    private List<Message> messageList = new ArrayList<Message>();
    private volatile boolean bFirst = true;
    private static final int MAX_MESSAGE_COUNT = 50;

    public PackagedMessage() {
        this.setConcreteType(Message.MessageClassType.BytesMessage);
        this.setOriginType(Message.MessageClassType.PackagedMessage);
        super.setMessageType("PackagedMessage");
    }

    public PackagedMessage(byte[] msgId) {
        this.setMessageId(msgId);
        this.setConcreteType(Message.MessageClassType.BytesMessage);
        this.setOriginType(Message.MessageClassType.PackagedMessage);
        super.setMessageType("PackagedMessage");
    }

    public void addMessage(Message message) {
        if (message instanceof PackagedMessage) {
            throw new NotifyClientIllegalArgumentException("\u4e0d\u80fd\u6dfb\u52a0PackagedMessage\u5230PackagedMessage\u4e2d");
        }
        if (null == message.getMessageType()) {
            throw new NotifyClientIllegalArgumentException("\u6dfb\u52a0\u7684Message\u6ca1\u6709MessageType");
        }
        if (this.bFirst) {
            this.setTopic(message.getTopic());
            this.bFirst = false;
        } else if (!this.getTopic().equals(message.getTopic())) {
            throw new NotifyClientIllegalArgumentException("\u4e0d\u652f\u6301\u4e00\u6b21\u6027\u4f20\u8f93\u591a\u4e2aTopic\u4e0d\u540c\u7684Message");
        }
        if (50 < this.messageList.size()) {
            throw new NotifyClientException("\u4e00\u6b21\u6700\u591a\u6027\u4f20\u8f9350\u4e2aMessage");
        }
        this.messageList.add(message);
    }

    public void removeMessage(Message message) {
        this.messageList.remove(message);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.messageList == null ? 0 : ((Object)this.messageList).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackagedMessage other = (PackagedMessage)obj;
        if (this.messageList == null ? other.messageList != null : !((Object)this.messageList).equals(other.messageList)) {
            return false;
        }
        return super.equals(obj);
    }

    public List<Message> getMessageList() {
        return new ArrayList<Message>(this.messageList);
    }

    public void setMessageList(List<Message> messageList) {
        if (messageList == null) {
            throw new NullPointerException("message list is null");
        }
        if (50 < messageList.size()) {
            throw new IllegalArgumentException("\u4e00\u6b21\u6700\u591a\u6027\u4f20\u8f9350\u4e2aMessage");
        }
        String topic = null;
        for (Message message : messageList) {
            if (message instanceof PackagedMessage) {
                throw new NotifyClientIllegalArgumentException("\u4e0d\u80fd\u6dfb\u52a0PackagedMessage\u5230PackagedMessage\u4e2d");
            }
            if (null == message.getMessageType()) {
                throw new NotifyClientIllegalArgumentException("\u6dfb\u52a0\u7684Message\u6ca1\u6709MessageType");
            }
            if (topic == null) {
                topic = message.getTopic();
                super.setTopic(topic);
                this.bFirst = false;
            }
            if (topic.equals(message.getTopic())) continue;
            throw new NotifyClientIllegalArgumentException("\u4e0d\u652f\u6301\u4e00\u6b21\u6027\u4f20\u8f93\u591a\u4e2aTopic\u4e0d\u540c\u7684Message");
        }
        this.messageList = messageList;
    }

    public int getMessageListSize() {
        return this.messageList.size();
    }

    public void clearPackage() {
        this.messageList.clear();
        this.bFirst = true;
    }

    @Override
    public void setTopic(String topic) {
        if (this.bFirst) {
            super.setTopic(topic);
        }
    }

    @Override
    public Message innerToProcessType() {
        List<Message> messageList = this.getMessageList();
        LinkedList<Message> newMessageList = new LinkedList<Message>();
        for (Message message : messageList) {
            Message newMessage = message.toProcessType();
            newMessageList.add(newMessage);
        }
        this.setMessageList(newMessageList);
        return this;
    }

    @Override
    public Message innerToSendType(MessageProperties properties) {
        List<Message> messageList = this.getMessageList();
        LinkedList<Message> newMessageList = new LinkedList<Message>();
        ListIterator<Message> iterator = messageList.listIterator();
        while (iterator.hasNext()) {
            Message message = iterator.next();
            message.setCommitted(this.isCommitted());
            message.setGroupId(this.getGroupId());
            Message newMessage = message.toSendType(properties);
            newMessageList.add(newMessage);
        }
        this.setMessageList(newMessageList);
        return this;
    }

    @Override
    public void clearProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBooleanProperty(String property) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getBornTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByteProperty(String property) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public Message.Charset getCharset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getDeliverCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDLQTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDoubleProperty(String property) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloatProperty(String property) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getGMTLastDelivery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIntProperty(String property) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLongProperty(String property) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPostTimeout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPriority() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> getProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getPropertyNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShortProperty(String property) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStringProperty(String property) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTargetGroup() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTimeToLive() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean propertyExists(String property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMessageType(String messageType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setByteProperty(String property, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDoubleProperty(String property, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloatProperty(String property, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIntProperty(String property, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLongProperty(String property, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShortProperty(String property, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStringProperty(String property, String value) {
        throw new UnsupportedOperationException();
    }
}

