/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.message;

import com.taobao.notify.client.exception.NotifyClientCodecException;
import com.taobao.notify.common.config.MessageProperties;
import com.taobao.notify.message.Message;
import com.taobao.notify.message.MessageConverter;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class StreamMessage
extends Message {
    static final long serialVersionUID = 47719002335L;
    static final int DEFAULT_CAPACITY = 1024;
    private transient ByteBuffer buffer;
    private boolean readable = false;
    private boolean writable = true;

    public boolean isReadable() {
        return this.readable;
    }

    void setReadable(boolean readable) {
        this.readable = readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    void setWritable(boolean writable) {
        this.writable = writable;
    }

    public StreamMessage() {
        this.setConcreteType(Message.MessageClassType.BytesMessage);
        this.setOriginType(Message.MessageClassType.StreamMessage);
        this.buffer = ByteBuffer.allocate(1024);
    }

    public StreamMessage(byte[] msgId) {
        this.setMessageId(msgId);
        this.setConcreteType(Message.MessageClassType.BytesMessage);
        this.setOriginType(Message.MessageClassType.StreamMessage);
        this.buffer = ByteBuffer.allocate(1024);
    }

    void setBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("Null buffer");
        }
        this.buffer = buffer;
    }

    private void increaseBufferCapatity() {
        if (this.buffer == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        int capacity = this.buffer.capacity() + 1024;
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity can't be negative");
        }
        ByteBuffer result = this.buffer.isDirect() ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        result.order(this.buffer.order());
        this.buffer.flip();
        result.put(this.buffer);
        this.buffer = result;
    }

    public StreamMessage writeByte(byte value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        this.ensureRemaining(1);
        this.buffer.put(value);
        return this;
    }

    public byte readByte() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        return this.buffer.get();
    }

    public StreamMessage writeShort(short value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        this.ensureRemaining(2);
        this.buffer.putShort(value);
        return this;
    }

    public short readShort() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        return this.buffer.getShort();
    }

    public StreamMessage writeInt(int value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        this.ensureRemaining(4);
        this.buffer.putInt(value);
        return this;
    }

    public int readInt() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        return this.buffer.getInt();
    }

    public StreamMessage writeLong(long value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        this.ensureRemaining(8);
        this.buffer.putLong(value);
        return this;
    }

    public long readLong() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        return this.buffer.getLong();
    }

    public StreamMessage writeFloat(float value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        this.ensureRemaining(4);
        this.buffer.putFloat(value);
        return this;
    }

    public float readFloat() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        return this.buffer.getFloat();
    }

    public StreamMessage writeDouble(double value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        this.ensureRemaining(8);
        this.buffer.putDouble(value);
        return this;
    }

    public double readDouble() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        return this.buffer.getDouble();
    }

    public StreamMessage write(byte[] bytes) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        if (bytes == null) {
            throw new NullPointerException("Null byte array");
        }
        this.ensureRemaining(bytes.length);
        this.buffer.put(bytes);
        return this;
    }

    public StreamMessage read(byte[] dst) {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        this.buffer.get(dst);
        return this;
    }

    public StreamMessage read(byte[] dst, int offset, int length) {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        this.buffer.get(dst, offset, length);
        return this;
    }

    private static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    public StreamMessage write(byte[] bytes, int offset, int length) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        if (bytes == null) {
            throw new NullPointerException("Null byte array");
        }
        StreamMessage.checkBounds(offset, length, bytes.length);
        this.ensureRemaining(length);
        this.buffer.put(bytes, offset, length);
        return this;
    }

    public StreamMessage writeString(String value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u5199");
        }
        if (value == null) {
            throw new NullPointerException("Null String value");
        }
        Message.Charset charset = this.getCharset();
        try {
            byte[] bytes = value.getBytes(charset.toString());
            int length = bytes.length;
            this.writeInt(length);
            this.write(bytes);
            return this;
        }
        catch (UnsupportedEncodingException e) {
            throw new NotifyClientCodecException(e);
        }
    }

    public String readString() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        int length = this.readInt();
        if (length < 0) {
            throw new IndexOutOfBoundsException("\u975e\u6cd5\u5b57\u7b26\u4e32\u957f\u5ea6:" + length);
        }
        if (this.buffer.remaining() < length) {
            throw new BufferUnderflowException();
        }
        byte[] bytes = new byte[length];
        this.read(bytes);
        Message.Charset charset = this.getCharset();
        try {
            return new String(bytes, charset.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new NotifyClientCodecException(e);
        }
    }

    public int available() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        return this.buffer.remaining();
    }

    public int skip(int skip) {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        int remaining = this.buffer.remaining();
        if (skip > remaining) {
            this.buffer.position(this.buffer.limit());
            return remaining;
        }
        this.buffer.position(this.buffer.position() + skip);
        return skip;
    }

    public void mark() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        this.buffer.mark();
    }

    public void reset() {
        if (!this.isReadable()) {
            throw new IllegalStateException("\u6d88\u606f\u4e0d\u53ef\u8bfb");
        }
        this.buffer.reset();
    }

    private void ensureRemaining(int expect) {
        while (this.buffer.remaining() < expect) {
            this.increaseBufferCapatity();
        }
    }

    ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.buffer == null ? 0 : this.buffer.hashCode());
        result = 31 * result + (this.readable ? 1231 : 1237);
        result = 31 * result + (this.writable ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamMessage other = (StreamMessage)obj;
        if (this.buffer == null ? other.buffer != null : !this.buffer.equals(other.buffer)) {
            return false;
        }
        if (this.readable != other.readable) {
            return false;
        }
        if (this.writable != other.writable) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean contentEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamMessage other = (StreamMessage)obj;
        if (this.getTopic() == null ? other.getTopic() != null : !this.getTopic().equals(other.getTopic())) {
            return false;
        }
        if (this.getMessageType() == null ? other.getMessageType() != null : !this.getMessageType().equals(other.getMessageType())) {
            return false;
        }
        if (this.getGroupId() == null ? other.getGroupId() != null : !this.getGroupId().equals(other.getGroupId())) {
            return false;
        }
        return !(this.buffer == null ? other.buffer != null : !this.buffer.equals(other.buffer));
    }

    @Override
    public Message innerToProcessType() {
        return this;
    }

    @Override
    public Message innerToSendType(MessageProperties properties) {
        if (this.readable) {
            throw new IllegalStateException("\u6d88\u606f\u4e3a\u53ea\u8bfb\uff0c\u65e0\u6cd5\u8f6c\u6362\u6210BytesMessage\u53d1\u9001");
        }
        return MessageConverter.toBytesMessage(this);
    }
}

