/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.subscription.eval;

import com.taobao.notify.message.Message;
import com.taobao.notify.subscription.eval.NotifyMessageMatchException;
import com.taobao.notify.utils.BeanUtils;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MessagePropertiesParser {
    public static final Set<String> EXPECT_PROPERTIES = new HashSet<String>();
    private static ConcurrentHashMap<Class, Method> clazz2propsGetterCache;

    public static Map<String, Object> getMessageProperties(Object obj) {
        if (obj == null) {
            throw new NotifyMessageMatchException("Null message");
        }
        Class<?> clazz = obj.getClass();
        HashMap<String, Object> result = new HashMap<String, Object>();
        BeanInfo beanInfo = BeanUtils.getBeanInfo((Object)obj);
        if (beanInfo == null) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        try {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                if (EXPECT_PROPERTIES.contains(propertyDescriptor.getName())) {
                    result.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod().invoke(obj, new Object[0]));
                }
                if (propertyDescriptor.getName().equals("deliveryCount")) {
                    result.put("deliverCount", propertyDescriptor.getReadMethod().invoke(obj, new Object[0]));
                }
                if (!propertyDescriptor.getName().equals("DLQTime")) continue;
                result.put("dlqTime", propertyDescriptor.getReadMethod().invoke(obj, new Object[0]));
            }
            Method method = MessagePropertiesParser.getUserDefinedPropertiesGetter(obj, clazz);
            if (method == null) {
                throw new NullPointerException("Null method for getting user defined properties");
            }
            Map properties = (Map)method.invoke(obj, new Object[0]);
            result.put("property", properties);
        }
        catch (Exception e) {
            throw new NotifyMessageMatchException(e);
        }
        return result;
    }

    private static Method getUserDefinedPropertiesGetter(Object obj, Class clazz) throws NoSuchMethodException {
        Method method = clazz2propsGetterCache.get(clazz);
        if (method == null) {
            method = obj instanceof Message ? clazz.getMethod("getProperties", new Class[0]) : clazz.getMethod("getUserDefinedProperties", new Class[0]);
            clazz2propsGetterCache.put(clazz, method);
        }
        return method;
    }

    static {
        EXPECT_PROPERTIES.add("GMTCreate");
        EXPECT_PROPERTIES.add("GMTLastDelivery");
        EXPECT_PROPERTIES.add("timeToLive");
        EXPECT_PROPERTIES.add("sendOnceMessage");
        EXPECT_PROPERTIES.add("deliverCount");
        EXPECT_PROPERTIES.add("messageType");
        EXPECT_PROPERTIES.add("groupId");
        EXPECT_PROPERTIES.add("committed");
        EXPECT_PROPERTIES.add("bornTime");
        EXPECT_PROPERTIES.add("dlqTime");
        EXPECT_PROPERTIES.add("priority");
        EXPECT_PROPERTIES.add("property");
        clazz2propsGetterCache = new ConcurrentHashMap();
    }
}

