/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.notify.tools;

public class DataIdTools {
    private static String SERVER_CONFIG_PREFIX = "NS_ServerConfig_";
    private static String SUBSCRIPTION_INFO_PREFIX = "NS_SubscriptionInfo_";
    private static String SUBSCRIPTION_BINDING_INFO_PREFIX = "NS_Notify_SubscriptionInfo_Binding";
    private static String SERVERS_PREFIX = "NS_Servers_";
    private static String SERVERS_PUB_PREFIX = "NS_Pub_Servers_";
    private static String SERVERS_SUB_PREFIX = "NS_Sub_Servers_";
    private static String SERVER_NS_HAPM_STATUS_PREFIX = "NS_HAPM_DataSource_Status";
    private static String UNUSED_MESSAGE_TYPE_PREFIX = "NS_UNUSED_MESSAGE";
    private static String TOPIC_ALL_MESSAGE_TYPE_PREFIX = "NS_TOPIC_ALL_MESSAGE";
    private static String DIAMOND__DATA_ID_PREFIX = "NS_DIAMOND_TOPIC_";
    private static String DIAMOND_SUBSCRIPTION_DATA_ID_PREFIX = "NS_DIAMOND_SUBSCRIPTION_TOPIC_";
    private static String DIAMOND_SERVERS_PUB_PREFIX = "NS_DIAMOND_Pub_Servers_";
    private static String DIAMOND_SERVERS_SUB_PREFIX = "NS_DIAMOND_Sub_Servers_";
    public static String DIAMOND_ROOMBALANCE_SERVER = "NS_DIAMOND_ROOMBALANCE_SERVER";
    public static String DIAMOND_ROOMBALANCE_CLIENT = "NS_DIAMOND_ROOMBALANCE_CLIENT";
    private static String DIAMOND_DATABASE_WEIGHT = "NS_DIAMOND_DATABASE_WEIGHT";
    public static String NS_DIAMOND_PROJECT_INFO_ID = "NS_DIAMOND_PROJECT_INFO_ID";
    public static final String DEFAULT_GROUP = "DEFAULT_GROUP";

    public static String getNSServerConfigDataId(String serverTag) {
        return SERVER_CONFIG_PREFIX + serverTag;
    }

    public static String getNSDiamondDataBaseWeightDataId(String appName) {
        return DIAMOND_DATABASE_WEIGHT + "_" + appName;
    }

    public static boolean isNSServerConfigDataId(String dataId) {
        return dataId.startsWith(SERVER_CONFIG_PREFIX);
    }

    public static String getNSSubscriptionInfoDataId(String topic) {
        return SUBSCRIPTION_INFO_PREFIX + topic;
    }

    public static String getNotifySubscriptionBindingInfoDataId(String topic) {
        return SUBSCRIPTION_BINDING_INFO_PREFIX + topic;
    }

    public static boolean isNotifySubscriptionBindingInfoDataId(String dataId) {
        return dataId.startsWith(SUBSCRIPTION_BINDING_INFO_PREFIX);
    }

    public static boolean isNSSubscriptionInfoDataId(String dataId) {
        return dataId.startsWith(SUBSCRIPTION_INFO_PREFIX);
    }

    public static boolean isNSHAPMStatusInfoDataId(String dataId) {
        return dataId.startsWith(SERVER_NS_HAPM_STATUS_PREFIX);
    }

    public static String getTopicFromNSSubscriptionInfoDataId(String dataId) {
        return dataId.substring(dataId.indexOf(SUBSCRIPTION_INFO_PREFIX) + SUBSCRIPTION_INFO_PREFIX.length());
    }

    public static String getTopicFromNotifySubscriptionBindingInfoDataId(String dataId) {
        return dataId.substring(dataId.indexOf(SUBSCRIPTION_BINDING_INFO_PREFIX) + SUBSCRIPTION_BINDING_INFO_PREFIX.length());
    }

    public static String getNSServersDataId(String topic) {
        return SERVERS_PREFIX + topic;
    }

    public static String getNSHAPMStatusDataId() {
        return SERVER_NS_HAPM_STATUS_PREFIX;
    }

    public static boolean isNSServersDataId(String dataId) {
        return dataId.startsWith(SERVERS_PREFIX);
    }

    public static String getTopicFromNSServersDataId(String dataId) {
        return dataId.substring(dataId.indexOf(SERVERS_PREFIX) + SERVERS_PREFIX.length());
    }

    public static String getNSServersPubDataId(String topic) {
        return SERVERS_PUB_PREFIX + topic;
    }

    public static boolean isNSServersPubDataId(String dataId) {
        return dataId.startsWith(SERVERS_PUB_PREFIX);
    }

    public static String getTopicFromNSServersPubDataId(String dataId) {
        return dataId.substring(dataId.indexOf(SERVERS_PUB_PREFIX) + SERVERS_PUB_PREFIX.length());
    }

    public static String getNSServersSubDataId(String topic) {
        return SERVERS_SUB_PREFIX + topic;
    }

    public static boolean isNSServersSubDataId(String dataId) {
        return dataId.startsWith(SERVERS_SUB_PREFIX);
    }

    public static String getTopicFromNSServersSubDataId(String dataId) {
        return dataId.substring(dataId.indexOf(SERVERS_SUB_PREFIX) + SERVERS_SUB_PREFIX.length());
    }

    public static String getTopicAllMessageType() {
        return TOPIC_ALL_MESSAGE_TYPE_PREFIX;
    }

    public static boolean isTopicAllMessageTypeDataId(String dataId) {
        return dataId.startsWith(TOPIC_ALL_MESSAGE_TYPE_PREFIX);
    }

    public static String getUnusedMessageType() {
        return UNUSED_MESSAGE_TYPE_PREFIX;
    }

    public static boolean isUnusedMessageTypeDataId(String dataId) {
        return dataId.startsWith(UNUSED_MESSAGE_TYPE_PREFIX);
    }

    public static String buildDiamondDataId(String topic) {
        return DIAMOND__DATA_ID_PREFIX + topic;
    }

    public static String getDiamondDataIdTopic(String dataId) {
        return dataId.substring(dataId.indexOf(DIAMOND__DATA_ID_PREFIX) + DIAMOND__DATA_ID_PREFIX.length());
    }

    public static String buildDiamondSubscriptionDataId(String topic) {
        return DIAMOND_SUBSCRIPTION_DATA_ID_PREFIX + topic;
    }

    public static String buildDiamondPubServersDataId(String topic) {
        return DIAMOND_SERVERS_PUB_PREFIX + topic;
    }

    public static String getDiamondPubServersTopic(String dataId) {
        return dataId.substring(dataId.indexOf(DIAMOND_SERVERS_PUB_PREFIX) + DIAMOND_SERVERS_PUB_PREFIX.length());
    }

    public static String buildDiamondSubServersDataId(String topic) {
        return DIAMOND_SERVERS_SUB_PREFIX + topic;
    }

    public static String getDiamondSubServersTopic(String dataId) {
        return dataId.substring(dataId.indexOf(DIAMOND_SERVERS_SUB_PREFIX) + DIAMOND_SERVERS_SUB_PREFIX.length());
    }

    public static String getDiamondSubscriptionDataId(String dataId) {
        return dataId.substring(dataId.indexOf(DIAMOND_SUBSCRIPTION_DATA_ID_PREFIX) + DIAMOND_SUBSCRIPTION_DATA_ID_PREFIX.length());
    }

    public static String getTopicFromNSDataId(String dataId) {
        if (DataIdTools.isNSServersSubDataId(dataId)) {
            return DataIdTools.getTopicFromNSServersSubDataId(dataId);
        }
        if (DataIdTools.isNSServersPubDataId(dataId)) {
            return DataIdTools.getTopicFromNSServersPubDataId(dataId);
        }
        if (DataIdTools.isNSServersDataId(dataId)) {
            return DataIdTools.getTopicFromNSServersDataId(dataId);
        }
        throw new IllegalArgumentException("\u9519\u8bef\u7684NS_Server\u7684dataId\uff1a" + dataId);
    }
}

