/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarFile;

public class FileUtils {
    private static int BUFFER_SIZE = 0x100000;
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    public static File createTempDir(String prefix, String suffix) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = prefix + "-" + System.currentTimeMillis() + "-" + suffix;
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public static void listFiles(File dir, List<String> result) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                FileUtils.listFiles(file, result);
            }
        } else if (dir.isFile()) {
            result.add(dir.getAbsolutePath());
        }
    }

    public static void copyFile(File src, File dest) {
        try {
            FileUtils.copy(new FileInputStream(src), new FileOutputStream(dest));
        }
        catch (IOException e) {
            System.err.println("fail to copy file " + src + " to " + dest);
        }
    }

    public static void saveToFile(InputStream is, File file) {
        try {
            FileUtils.copy(is, new FileOutputStream(file));
        }
        catch (IOException e) {
            System.err.println("fail to save file " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            int read;
            is = new BufferedInputStream(is);
            os = new BufferedOutputStream(os);
            byte[] buffer = new byte[BUFFER_SIZE];
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
        }
        finally {
            FileUtils.silentClose(is);
            FileUtils.silentClose(os);
        }
    }

    public static void silentClose(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void silentClose(JarFile jarFile) {
        if (jarFile == null) {
            return;
        }
        try {
            jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

