/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.utils;

import com.taobao.pandora.boot.common.utils.AnsiLog;
import com.taobao.pandora.boot.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class DownloadUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String url, File dest) {
        URLConnection connection;
        block7: {
            File dir = dest.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            long timeStamp = -1L;
            if (dest.exists()) {
                timeStamp = dest.lastModified();
            }
            connection = null;
            try {
                connection = new URL(url).openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.setRequestProperty("User-Agent", "Pandora Boot Dev Tools");
                connection.setUseCaches(false);
                if (timeStamp > 0L) {
                    connection.setIfModifiedSince(timeStamp);
                }
                if (!DownloadUtils.shouldContinueToRead(connection)) break block7;
                FileUtils.saveToFile(connection.getInputStream(), dest);
            }
            catch (IOException e) {
                try {
                    AnsiLog.error((String)("fail to download " + url + " to " + dest));
                }
                catch (Throwable throwable) {
                    DownloadUtils.disconnectIfNecessary(connection);
                    throw throwable;
                }
                DownloadUtils.disconnectIfNecessary(connection);
            }
        }
        DownloadUtils.disconnectIfNecessary(connection);
    }

    private static boolean shouldContinueToRead(URLConnection connection) throws IOException {
        HttpURLConnection httpURLConnection;
        int responseCode;
        if (connection instanceof HttpURLConnection && (responseCode = (httpURLConnection = (HttpURLConnection)connection).getResponseCode()) != 200) {
            if (responseCode != 304) {
                AnsiLog.error((String)("access to " + connection.getURL() + " fails with error code " + responseCode));
            }
            return false;
        }
        return true;
    }

    private static void disconnectIfNecessary(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
            httpURLConnection.disconnect();
        }
    }
}

