/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.mvc.AbstractMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

@ConfigurationProperties(value="endpoints.endpoints")
public class EndPointsEndPoint
extends AbstractMvcEndpoint {
    @Autowired
    ConfigurableApplicationContext context;
    private List<AbstractUrlHandlerMapping> handlerMappings = Collections.emptyList();
    private List<AbstractHandlerMethodMapping<?>> methodMappings = Collections.emptyList();

    public EndPointsEndPoint() {
        super("/endpoints", false);
    }

    @RequestMapping
    @ResponseBody
    public List<Map<String, Object>> invoke() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        MvcEndpoints mvcEndpoints = (MvcEndpoints)this.context.getBean(MvcEndpoints.class);
        if (mvcEndpoints != null) {
            for (MvcEndpoint endpoint : mvcEndpoints.getEndpoints()) {
                HashMap<String, Object> endpointInfo = new HashMap<String, Object>();
                endpointInfo.put("sensitive", endpoint.isSensitive());
                endpointInfo.put("path", endpoint.getPath());
                if (endpoint.getEndpointType() != null) {
                    endpointInfo.put("endpointType", endpoint.getEndpointType().getName());
                } else {
                    endpointInfo.put("endpointType", endpoint.getClass().getName());
                }
                result.add(endpointInfo);
            }
        }
        return result;
    }

    @RequestMapping(value={"mappings"})
    @ResponseBody
    public Map<String, Object> mappings() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.extractHandlerMappings(this.handlerMappings, result);
        this.extractHandlerMappings((ApplicationContext)this.context, result);
        this.extractMethodMappings(this.methodMappings, result);
        this.extractMethodMappings((ApplicationContext)this.context, result);
        return result;
    }

    protected void extractMethodMappings(ApplicationContext applicationContext, Map<String, Object> result) {
        if (applicationContext != null) {
            for (Map.Entry bean : applicationContext.getBeansOfType(AbstractHandlerMethodMapping.class).entrySet()) {
                Map methods = ((AbstractHandlerMethodMapping)bean.getValue()).getHandlerMethods();
                for (Map.Entry method : methods.entrySet()) {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("bean", bean.getKey());
                    map.put("method", ((HandlerMethod)method.getValue()).toString());
                    result.put(method.getKey().toString(), map);
                }
            }
        }
    }

    protected void extractHandlerMappings(ApplicationContext applicationContext, Map<String, Object> result) {
        if (applicationContext != null) {
            Map mappings = applicationContext.getBeansOfType(AbstractUrlHandlerMapping.class);
            for (Map.Entry mapping : mappings.entrySet()) {
                Map<String, Object> handlers = this.getHandlerMap((AbstractUrlHandlerMapping)mapping.getValue());
                for (Map.Entry<String, Object> handler : handlers.entrySet()) {
                    result.put(handler.getKey(), Collections.singletonMap("bean", mapping.getKey()));
                }
            }
        }
    }

    private Map<String, Object> getHandlerMap(AbstractUrlHandlerMapping mapping) {
        if (AopUtils.isCglibProxy((Object)mapping)) {
            return Collections.emptyMap();
        }
        return mapping.getHandlerMap();
    }

    protected void extractHandlerMappings(Collection<AbstractUrlHandlerMapping> handlerMappings, Map<String, Object> result) {
        for (AbstractUrlHandlerMapping mapping : handlerMappings) {
            Map handlers = mapping.getHandlerMap();
            for (Map.Entry entry : handlers.entrySet()) {
                Class<?> handlerClass = entry.getValue().getClass();
                result.put((String)entry.getKey(), Collections.singletonMap("type", handlerClass.getName()));
            }
        }
    }

    protected void extractMethodMappings(Collection<AbstractHandlerMethodMapping<?>> methodMappings, Map<String, Object> result) {
        for (AbstractHandlerMethodMapping<?> mapping : methodMappings) {
            Map methods = mapping.getHandlerMethods();
            for (Map.Entry entry : methods.entrySet()) {
                result.put(String.valueOf(entry.getKey()), Collections.singletonMap("method", String.valueOf(entry.getValue())));
            }
        }
    }
}

