/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnWebApplication
@Order(value=0x7FFFFFFF)
@ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.ManagementServerProperties"})
@ConditionalOnProperty(name={"spring.managementSecurityDecetor.enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={ManagementSecurityDecetor.class})
public class ManagementSecurityAutoConfiguration {

    public static class ManagementSecurityDecetor {
        private static final Logger logger = LoggerFactory.getLogger(ManagementSecurityDecetor.class);
        @Autowired
        private ManagementServerProperties managementServerProperties;
        @Autowired
        private ServerProperties serverProperties;

        @PostConstruct
        public void init() {
            if (!this.isSafe()) {
                logger.error("server.port: {}, management.port:{}, is not safe!", (Object)this.serverProperties.getPort(), (Object)this.managementServerProperties.getPort());
                throw new IllegalArgumentException("spring management port is not safe! please add management.port=7002 into application.properties.");
            }
        }

        public boolean isSafe() {
            Integer managementPort = this.managementServerProperties.getPort();
            Integer serverPort = this.serverProperties.getPort();
            if (managementPort != null && managementPort < 0) {
                return true;
            }
            if (managementPort != null && (managementPort == 7001 || managementPort == 8080)) {
                logger.error("management.port: {}! is not a safe port!", (Object)managementPort);
                return false;
            }
            if (serverPort != null) {
                if (serverPort == 0) {
                    return managementPort != null;
                }
                if (serverPort < 0) {
                    return true;
                }
                if (managementPort == null) {
                    return false;
                }
                return !serverPort.equals(managementPort);
            }
            if (serverPort == null) {
                return managementPort != null;
            }
            return false;
        }

        public ManagementServerProperties getManagementServerProperties() {
            return this.managementServerProperties;
        }

        public void setManagementServerProperties(ManagementServerProperties managementServerProperties) {
            this.managementServerProperties = managementServerProperties;
        }

        public ServerProperties getServerProperties() {
            return this.serverProperties;
        }

        public void setServerProperties(ServerProperties serverProperties) {
            this.serverProperties = serverProperties;
        }
    }
}

