/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring;

import com.taobao.pandora.boot.common.utils.AnsiLog;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

@Order(value=1)
public class ProjectInfoInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String PROJECT_NAME = "project.name";
    private static final String SPRING_APPLICATION_NAME = "spring.application.name";
    private static final String DEFAULT_PROJECT_NAME = "pb-default-project-name";
    private static final String skipProjectInfoInitializer = "skipProjectInfoInitializer";

    public void initialize(ConfigurableApplicationContext context) {
        if (Boolean.getBoolean(skipProjectInfoInitializer)) {
            System.out.println("Skip ProjectInfoInitializer.");
            return;
        }
        ConfigurableEnvironment environment = context.getEnvironment();
        String _dProjectName = System.getProperty(PROJECT_NAME);
        String envProjectName = environment.getProperty(PROJECT_NAME);
        String _dApplicationName = System.getProperty(SPRING_APPLICATION_NAME);
        String envApplicationName = environment.getProperty(SPRING_APPLICATION_NAME);
        if (StringUtils.hasText((String)_dProjectName)) {
            System.setProperty(SPRING_APPLICATION_NAME, _dProjectName);
            System.out.println("Configure -Dspring.application.name from -Dproject.name " + _dProjectName);
        } else if (StringUtils.hasText((String)_dApplicationName)) {
            System.setProperty(PROJECT_NAME, _dApplicationName);
            System.out.println("Configure -Dproject.name from -Dspring.application.name " + _dApplicationName);
        } else if (StringUtils.hasText((String)envProjectName)) {
            System.setProperty(PROJECT_NAME, envProjectName);
            System.setProperty(SPRING_APPLICATION_NAME, envProjectName);
            System.out.println("Both configure -Dproject.name and -Dspring.application.name from spring environment project.name " + envProjectName);
        } else if (StringUtils.hasText((String)envApplicationName)) {
            System.setProperty(PROJECT_NAME, envApplicationName);
            System.setProperty(SPRING_APPLICATION_NAME, envApplicationName);
            System.out.println("Both configure -Dproject.name and -Dspring.application.name from spring environment spring.application.name " + envApplicationName);
        } else {
            System.setProperty(PROJECT_NAME, DEFAULT_PROJECT_NAME);
            System.setProperty(SPRING_APPLICATION_NAME, DEFAULT_PROJECT_NAME);
            AnsiLog.warn((String)"Cann't find project.name/spring.application.name, so set to: pb-default-project-name, you can set them through application.properties or -D argument.");
        }
    }
}

