/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring;

import com.taobao.pandora.boot.loader.util.ClassLoaderUtils;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public class ClassLoaderInfoUtils {
    public static Map<String, Object> info() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ClassLoader classLoader = ApplicationContext.class.getClassLoader();
        URL[] urls = ClassLoaderUtils.getUrls((ClassLoader)ApplicationContext.class.getClassLoader());
        result.put("urls", urls);
        result.put("description", "The ClassLoader of org.springframework.context.ApplicationContext.");
        result.put("classOfClassLoader", classLoader.getClass().getName());
        return result;
    }

    public static Map<String, Object> systemClassLoader() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ClassLoader classLoader = ApplicationContext.class.getClassLoader();
        URL[] urls = ClassLoaderUtils.getUrls((ClassLoader)ClassLoader.getSystemClassLoader());
        result.put("urls", urls);
        result.put("description", "The SystemClassLoader.");
        result.put("classOfClassLoader", classLoader.getClass().getName());
        return result;
    }

    public static String getResource(String name) {
        ClassLoader classLoader = ApplicationContext.class.getClassLoader();
        return "" + classLoader.getResource(name);
    }

    public static List<String> getResources(String name) throws IOException {
        ClassLoader classLoader = ApplicationContext.class.getClassLoader();
        Enumeration<URL> resources = classLoader.getResources(name);
        ArrayList<String> result = new ArrayList<String>();
        while (resources.hasMoreElements()) {
            result.add(resources.nextElement().toString());
        }
        return result;
    }

    public static Map<String, Object> getClass(String name) throws ClassNotFoundException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> clazz = Class.forName(name.replace('/', '.'));
        if (clazz != null) {
            CodeSource codeSource;
            ProtectionDomain protectionDomain;
            result.put("name", clazz.getName());
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                result.put("classloader", classLoader.getClass().getName());
            }
            if ((protectionDomain = clazz.getProtectionDomain()) != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                result.put("location", "" + protectionDomain.getCodeSource().getLocation());
            }
        }
        return result;
    }
}

