/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementPortUtils {
    private static final Logger logger = LoggerFactory.getLogger(ManagementPortUtils.class);

    public static boolean isSafe(Integer serverPort, Integer managementPort) {
        if (managementPort != null && managementPort < 0) {
            return true;
        }
        if (managementPort != null && (managementPort == 7001 || managementPort == 8080)) {
            logger.error("management port: {}! is not a safe port!", (Object)managementPort);
            return false;
        }
        if (serverPort != null) {
            if (serverPort == 0) {
                return managementPort != null;
            }
            if (serverPort < 0) {
                return true;
            }
            if (managementPort == null) {
                return false;
            }
            return !serverPort.equals(managementPort);
        }
        if (serverPort == null) {
            return managementPort != null;
        }
        return false;
    }
}

