/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderInspector {
    private static final Map<String, Boolean> CLASS_NOT_FOUND_MAP = new ConcurrentHashMap<String, Boolean>();

    public static Set<String> getClassNotFoundList() {
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Class<?> clazz = classLoader.loadClass(ClassLoaderInspector.class.getName());
            Field field = clazz.getDeclaredField("CLASS_NOT_FOUND_MAP");
            field.setAccessible(true);
            Class<?> mapClazz = classLoader.loadClass(Map.class.getName());
            Method keySetMethod = mapClazz.getMethod("keySet", new Class[0]);
            return (Set)keySetMethod.invoke(field.get(null), new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return CLASS_NOT_FOUND_MAP.keySet();
    }

    public static void addClassNotFounds(String name) {
        if (!name.startsWith("com") || name.startsWith("com.taobao.pandora") || name.startsWith("com.alibaba.boot") || name.startsWith("com.fasterxml") || name.startsWith("com.google") || name.startsWith("com.ibm") || name.startsWith("com.sun") || name.startsWith("com.mongodb")) {
            return;
        }
        if (ClassLoaderInspector.getClassNotFoundList().size() <= 512) {
            CLASS_NOT_FOUND_MAP.put(name, true);
        }
    }
}

