/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.boot.loader.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class ComponentsManager {
    private List<Component> components = Collections.emptyList();

    public void initComponents() {
        System.out.println("Init available components");
        this.components = this.scanForAvailableComponents();
        for (Component component : this.components) {
            System.out.println("Init component " + component.getName());
            component.init();
        }
    }

    public void startComponents() {
        System.out.println("Starting available components");
        for (Component component : this.components) {
            System.out.println("Start component " + component.getName());
            component.start();
        }
    }

    public void stopComponents() {
        System.out.println("Stopping available components");
        for (Component component : this.components) {
            System.out.println("Stop component " + component.getName());
            component.stop();
        }
    }

    private List<Component> scanForAvailableComponents() {
        System.out.println("Scanning for available components in the runtime");
        ArrayList<Component> servers = new ArrayList<Component>();
        ServiceLoader<Component> components = ServiceLoader.load(Component.class);
        for (Component component : components) {
            servers.add(component);
        }
        return servers;
    }
}

