/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.boot.loader.util.ComponentsManagerLoadUtils;
import java.lang.reflect.Method;

public class LaunchRunner
implements Runnable {
    private final String startClassName;
    private final String[] args;

    public LaunchRunner(String startClassName, String ... args) {
        this.startClassName = startClassName;
        this.args = args != null ? args : new String[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        Object componentManager = ComponentsManagerLoadUtils.getInstance(classLoader);
        try {
            ComponentsManagerLoadUtils.initComponentsManager(componentManager);
            ComponentsManagerLoadUtils.startComponentsManager(componentManager);
            Class<?> startClass = classLoader.loadClass(this.startClassName);
            Method mainMethod = startClass.getMethod("main", String[].class);
            if (!mainMethod.isAccessible()) {
                mainMethod.setAccessible(true);
            }
            mainMethod.invoke(null, new Object[]{this.args});
        }
        catch (NoSuchMethodException ex) {
            Exception wrappedEx = new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", ex);
            thread.getThreadGroup().uncaughtException(thread, wrappedEx);
        }
        catch (Exception ex) {
            thread.getThreadGroup().uncaughtException(thread, ex);
        }
        finally {
            ComponentsManagerLoadUtils.stopComponentsManager(componentManager);
        }
    }

    public static void join(ThreadGroup threadGroup) {
        boolean hasNonDaemonThreads;
        do {
            hasNonDaemonThreads = false;
            Thread[] threads = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threads);
            for (Thread thread : threads) {
                if (thread == null || thread.isDaemon()) continue;
                try {
                    hasNonDaemonThreads = true;
                    thread.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (hasNonDaemonThreads);
    }
}

