/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.boot.loader.BaseLaunchURLClassLoader;
import com.taobao.pandora.boot.loader.ClassLoaderInspector;
import com.taobao.pandora.loader.jar.Handler;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public class ReLaunchURLClassLoader
extends BaseLaunchURLClassLoader {
    private static LockProvider LOCK_PROVIDER = ReLaunchURLClassLoader.setupLockProvider();
    private final ClassLoader rootClassLoader;
    private final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
    private final String RESOURCE_WHITE_LIST_HOTSWAP = "org/hotswap/agent";
    private String[] selfLoadPackages = null;
    private List<String> selfLoadExcludes = null;

    public ReLaunchURLClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, null, null, parent);
    }

    public ReLaunchURLClassLoader(URL[] urls, String[] selfLoadPackages, String[] selfLoadExcludes, ClassLoader parent) {
        super(urls, parent);
        this.rootClassLoader = this.findRootClassLoader(parent);
        this.selfLoadPackages = selfLoadPackages;
        if (selfLoadExcludes != null) {
            this.selfLoadExcludes = Arrays.asList(selfLoadExcludes);
        }
    }

    private ClassLoader findRootClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader.getParent() == null) {
                return classLoader;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    public void setClassCache(Map<String, Class<?>> classCache) {
        this.classCache = classCache;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.rootClassLoader != null) {
            url = this.rootClassLoader.getResource(name);
        }
        if (url == null) {
            url = this.findResource(name);
        }
        return url == null && name.startsWith("org/hotswap/agent") ? this.systemClassLoader.getResource(name) : url;
    }

    @Override
    public URL findResource(String name) {
        URL uRL;
        Handler.setUseFastConnectionExceptions((boolean)true);
        try {
            uRL = super.findResource(name);
        }
        catch (Throwable throwable) {
            try {
                Handler.setUseFastConnectionExceptions((boolean)false);
                throw throwable;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        Handler.setUseFastConnectionExceptions((boolean)false);
        return uRL;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Handler.setUseFastConnectionExceptions((boolean)true);
        try {
            Enumeration<URL> enumeration = super.findResources(name);
            return enumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions((boolean)false);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urlsFromClassLoader = this.findResources(name);
        if ((urlsFromClassLoader == null || !urlsFromClassLoader.hasMoreElements()) && name.startsWith("org/hotswap/agent")) {
            urlsFromClassLoader = this.systemClassLoader.getResources(name);
        }
        if (this.rootClassLoader != null) {
            return new ResourceEnumeration(this.rootClassLoader.getResources(name), urlsFromClassLoader);
        }
        return urlsFromClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = LOCK_PROVIDER.getLock(this, name);
        synchronized (object) {
            Class<?> loadedClass;
            if (this.classCache != null && this.classCache.containsKey(name)) {
                return (Class)this.classCache.get(name);
            }
            if (this.selfLoadPackages != null) {
                for (String selfLoadPackage : this.selfLoadPackages) {
                    if (!name.startsWith(selfLoadPackage) || this.selfLoadExcludes != null && this.selfLoadExcludes.contains(name)) continue;
                    return ReLaunchURLClassLoader.class.getClassLoader().loadClass(name);
                }
            }
            if ((loadedClass = this.findLoadedClass(name)) == null) {
                Handler.setUseFastConnectionExceptions((boolean)true);
                try {
                    loadedClass = this.doLoadClass(name);
                }
                catch (ClassNotFoundException e) {
                    ClassLoaderInspector.addClassNotFounds(name);
                    throw e;
                }
                finally {
                    Handler.setUseFastConnectionExceptions((boolean)false);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            super.recordClass(loadedClass);
            return loadedClass;
        }
    }

    private Class<?> doLoadClass(String name) throws ClassNotFoundException {
        try {
            if (this.rootClassLoader != null) {
                return this.rootClassLoader.loadClass(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.findPackage(name);
            Class<?> cls = this.findClass(name);
            return cls;
        }
        catch (Exception exception) {
            try {
                return this.systemClassLoader.loadClass(name);
            }
            catch (Exception exception2) {
                return super.loadClass(name, false);
            }
        }
    }

    private void findPackage(String name) throws ClassNotFoundException {
        String packageName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1 && this.getPackage(packageName = name.substring(0, lastDot)) == null) {
            try {
                this.definePackageForFindClass(name, packageName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void definePackageForFindClass(final String name, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ClassNotFoundException {
                    String packageEntryName = packageName.replace('.', '/') + "/";
                    String classEntryName = name.replace('.', '/') + ".class";
                    for (URL url : ReLaunchURLClassLoader.this.getURLs()) {
                        try {
                            JarFile jarFile;
                            URLConnection connection = url.openConnection();
                            if (!(connection instanceof JarURLConnection) || (jarFile = ((JarURLConnection)connection).getJarFile()).getEntry(classEntryName) == null || jarFile.getEntry(packageEntryName) == null || jarFile.getManifest() == null) continue;
                            ReLaunchURLClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            return null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static LockProvider setupLockProvider() {
        try {
            ClassLoader.registerAsParallelCapable();
            return new Java7LockProvider();
        }
        catch (NoSuchMethodError ex) {
            return new LockProvider();
        }
    }

    private static class ResourceEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> rootResources = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }
        };
        private final Enumeration<URL> systemResources;
        private final Enumeration<URL> localResources;

        ResourceEnumeration(Enumeration<URL> systemResources, Enumeration<URL> localResources) {
            this.systemResources = systemResources;
            this.localResources = localResources;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                Handler.setUseFastConnectionExceptions((boolean)true);
                boolean bl = this.rootResources.hasMoreElements() || this.systemResources.hasMoreElements() || this.localResources.hasMoreElements();
                return bl;
            }
            finally {
                Handler.setUseFastConnectionExceptions((boolean)false);
            }
        }

        @Override
        public URL nextElement() {
            if (this.rootResources.hasMoreElements()) {
                return this.rootResources.nextElement();
            }
            if (this.systemResources.hasMoreElements()) {
                return this.systemResources.nextElement();
            }
            return this.localResources.nextElement();
        }
    }

    private static class Java7LockProvider
    extends LockProvider {
        private Java7LockProvider() {
        }

        @Override
        public Object getLock(ReLaunchURLClassLoader classLoader, String className) {
            return classLoader.getClassLoadingLock(className);
        }
    }

    private static class LockProvider {
        private LockProvider() {
        }

        public Object getLock(ReLaunchURLClassLoader classLoader, String className) {
            return classLoader;
        }
    }
}

