/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.jmx;

import com.taobao.pandora.boot.loader.jmx.JmxLocalConnector;
import com.taobao.pandora.boot.loader.jmx.cmd.Command;
import javax.management.MBeanServerConnection;

public class Executor {
    private static final String EXIT_TIMEOUT = "exit.timeout";
    private static int defaultExitTimeout = 30;
    private static JmxLocalConnector connector = new JmxLocalConnector();
    private static MBeanServerConnection server;
    private static String projectName;

    public static void main(String[] args) {
        try {
            Executor.startTimeoutExitThread();
            Executor.init();
            Executor.execute(args[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Executor.help();
            System.exit(-1);
        }
        finally {
            connector.disConnect();
        }
    }

    private static void help() {
        System.out.println();
        System.out.println();
        System.out.println("Usage: java -Dpid=${pid} -Dproject.name=${project.name} -classpath /path/to/your/project com.taobao.pandora.boot.loader.jmx.Executor preload|shutdown");
    }

    private static void init() throws Exception {
        projectName = System.getProperty("project.name", "default");
        if (projectName == null) {
            throw new InstantiationException("-Dproject.name should be set");
        }
        String servicePid = System.getProperty("pid");
        if (servicePid == null) {
            throw new InstantiationException("-Dpid should be set");
        }
        server = connector.connect(servicePid);
    }

    private static Object execute(String operate) throws Exception {
        Command executor = Command.getLocalCommand(operate, projectName);
        if (executor != null) {
            return executor.execute(server);
        }
        throw new IllegalArgumentException("Can't find Command for operate: " + operate);
    }

    private static void startTimeoutExitThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    defaultExitTimeout = Integer.parseInt(System.getProperty(Executor.EXIT_TIMEOUT, "" + defaultExitTimeout));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    Thread.sleep(defaultExitTimeout * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    System.err.println("Execute timeout, exit directly");
                    System.exit(-1);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }
}

