/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.jmx;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxLocalConnector {
    static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private VirtualMachine virtualmachine;
    private JMXConnector connector;

    public MBeanServerConnection connect(String pid) throws IOException {
        String address = this.attachJmx(pid);
        JMXServiceURL serviceURL = new JMXServiceURL(address);
        this.connector = JMXConnectorFactory.connect(serviceURL);
        return this.connector.getMBeanServerConnection();
    }

    public void disConnect() {
        if (this.virtualmachine != null) {
            try {
                this.virtualmachine.detach();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String startLocalManagementAgent(String pid) throws IOException {
        VirtualMachine vm;
        try {
            vm = VirtualMachine.attach(pid);
        }
        catch (AttachNotSupportedException e) {
            throw new IOException(e);
        }
        String connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
        if (connectorAddress == null) {
            try {
                Method method = VirtualMachine.class.getDeclaredMethod("startLocalManagementAgent", new Class[0]);
                method.invoke((Object)vm, new Object[0]);
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
            connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
        }
        return connectorAddress;
    }

    private static boolean supportStartLocalManagementAgent() {
        try {
            VirtualMachine.class.getDeclaredMethod("startLocalManagementAgent", new Class[0]);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private String attachJmx(String pid) throws IOException {
        if (JmxLocalConnector.supportStartLocalManagementAgent()) {
            return JmxLocalConnector.startLocalManagementAgent(pid);
        }
        try {
            this.virtualmachine = VirtualMachine.attach(pid);
        }
        catch (AttachNotSupportedException e) {
            throw new IOException(e);
        }
        String javaHome = this.virtualmachine.getSystemProperties().getProperty("java.home");
        String agentPath = javaHome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
        File file = new File(agentPath);
        if (!file.exists() && !(file = new File(agentPath = javaHome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
            throw new IOException("Management agent not found");
        }
        agentPath = file.getCanonicalPath();
        try {
            this.virtualmachine.loadAgent(agentPath, "com.sun.management.jmxremote");
        }
        catch (AgentLoadException e) {
            throw new IOException(e);
        }
        catch (AgentInitializationException agentinitializationexception) {
            throw new IOException(agentinitializationexception);
        }
        Properties properties = this.virtualmachine.getAgentProperties();
        String address = (String)properties.get(CONNECTOR_ADDRESS);
        this.virtualmachine.detach();
        return address;
    }
}

