/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.util;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class SystemPrintLogger {
    private static final String SYSTEM_LOGGER_STACK_DEPTH = "pandora.boot.syslogger.stack.depth";
    private static int STACK_DEPTH = 3;
    private static final String format = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS,%1$tL %2$s %3$s %4$s%n%5$s: %6$s";
    private static final String formatln = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS,%1$tL %2$s %3$s %4$s%n%5$s: %6$s%n";
    private PrintStream printer;
    private String name;

    public SystemPrintLogger(String name, PrintStream printer) {
        this.name = name;
        this.printer = printer;
    }

    public void print(String msg) {
        StackTraceElement[] locations = Thread.currentThread().getStackTrace();
        this.doPrint(msg, locations, false);
    }

    public void println(String msg) {
        StackTraceElement[] locations = Thread.currentThread().getStackTrace();
        this.doPrint(msg, locations, true);
    }

    protected void doPrint(String msg, StackTraceElement[] locations, boolean wrap) {
        boolean isPrintStack = false;
        for (int i = 0; i < locations.length; ++i) {
            StackTraceElement caller = locations[i];
            if (!"java.lang.Throwable".equals(caller.getClassName()) || !"printStackTrace".equals(caller.getMethodName())) continue;
            isPrintStack = true;
            break;
        }
        if (isPrintStack) {
            if (wrap) {
                this.printer.println(msg);
            } else {
                this.printer.print(msg);
            }
        } else {
            StackTraceElement caller = locations[STACK_DEPTH];
            String sourceClass = caller.getClassName();
            String sourceMethod = caller.getMethodName();
            int sourceLine = caller.getLineNumber();
            if (wrap) {
                this.printer.format(formatln, new Date(), sourceClass, sourceMethod, sourceLine, this.name, msg);
            } else {
                this.printer.format(format, new Date(), sourceClass, sourceMethod, sourceLine, this.name, msg);
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.printer.write(b);
    }

    public void write(int b) {
        this.printer.write(b);
    }

    public void write(byte[] b, int off, int len) {
        this.printer.write(b, off, len);
    }

    static {
        String sd = System.getProperty(SYSTEM_LOGGER_STACK_DEPTH);
        if (sd != null) {
            try {
                int depth;
                STACK_DEPTH = depth = Integer.parseInt(sd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

