/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.jmx;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxLocalConnector {
    private VirtualMachine virtualmachine;
    private JMXConnector connector;

    public MBeanServerConnection connect(String pid) throws IOException {
        String address = this.attachJmx(pid);
        JMXServiceURL serviceURL = new JMXServiceURL(address);
        this.connector = JMXConnectorFactory.connect(serviceURL);
        return this.connector.getMBeanServerConnection();
    }

    public void disConnect() {
        if (this.virtualmachine != null) {
            try {
                this.virtualmachine.detach();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String attachJmx(String pid) throws IOException {
        try {
            this.virtualmachine = VirtualMachine.attach(pid);
        }
        catch (AttachNotSupportedException e) {
            throw new IOException(e);
        }
        String javaHome = this.virtualmachine.getSystemProperties().getProperty("java.home");
        String agentPath = javaHome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
        File file = new File(agentPath);
        if (!file.exists() && !(file = new File(agentPath = javaHome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
            throw new IOException("Management agent not found");
        }
        agentPath = file.getCanonicalPath();
        try {
            this.virtualmachine.loadAgent(agentPath, "com.sun.management.jmxremote");
        }
        catch (AgentLoadException e) {
            throw new IOException(e);
        }
        catch (AgentInitializationException agentinitializationexception) {
            throw new IOException(agentinitializationexception);
        }
        Properties properties = this.virtualmachine.getAgentProperties();
        String address = (String)properties.get("com.sun.management.jmxremote.localConnectorAddress");
        this.virtualmachine.detach();
        return address;
    }
}

