/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.util;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.misc.Unsafe;

public class ClassLoaderUtils {
    public static URL[] getUrls(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        if (classLoader.getClass().getName().startsWith("jdk.internal.loader.ClassLoaders$")) {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Unsafe unsafe = (Unsafe)field.get(null);
                Field ucpField = classLoader.getClass().getDeclaredField("ucp");
                long ucpFieldOffset = unsafe.objectFieldOffset(ucpField);
                Object ucpObject = unsafe.getObject(classLoader, ucpFieldOffset);
                Field pathField = ucpField.getType().getDeclaredField("path");
                long pathFieldOffset = unsafe.objectFieldOffset(pathField);
                ArrayList path = (ArrayList)unsafe.getObject(ucpObject, pathFieldOffset);
                return path.toArray(new URL[path.size()]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static URL locateURL(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        ProtectionDomain pd = clazz.getProtectionDomain();
        if (null == pd) {
            return null;
        }
        CodeSource cs = pd.getCodeSource();
        if (null == cs) {
            return null;
        }
        return cs.getLocation();
    }
}

