/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.controller;

import com.taobao.tddl.client.controller.ColumnMetaData;
import com.taobao.tddl.client.controller.DatabaseExecutionContext;
import com.taobao.tddl.client.controller.DatabaseExecutionContextImp;
import com.taobao.tddl.client.controller.DispatcherResultImp;
import com.taobao.tddl.client.dispatcher.DispatcherResult;
import com.taobao.tddl.client.dispatcher.EXECUTE_PLAN;
import com.taobao.tddl.interact.bean.ReverseOutput;
import com.taobao.tddl.interact.bean.TargetDB;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.sqlobjecttree.SqlAndTableAtParser;
import com.taobao.tddl.sqlobjecttree.SqlParserResult;
import com.taobao.tddl.sqlobjecttree.Update;
import com.taobao.tddl.sqlobjecttree.outputhandlerimpl.HandlerContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ControllerUtils {
    public static void appendDatabaseSharedMetaData(Map<String, Comparative> mapList, DispatcherResultImp retMeta) {
        if (mapList == null) {
            return;
        }
        String uniqueColumnKey = ControllerUtils.getUniqueKey(retMeta);
        for (Map.Entry<String, Comparative> oneValue : mapList.entrySet()) {
            String sharedKey = ControllerUtils.toLowerCaseIgnoreNull(oneValue.getKey());
            if (sharedKey.equals(uniqueColumnKey)) continue;
            ColumnMetaData colMeta = new ColumnMetaData(sharedKey, oneValue.getValue());
            retMeta.addSplitDB(colMeta);
        }
    }

    public static String toLowerCaseIgnoreNull(String tobeDone) {
        if (tobeDone != null) {
            return tobeDone.toLowerCase();
        }
        return null;
    }

    protected static String getUniqueKey(DispatcherResultImp retMeta) {
        ColumnMetaData uniqueKey = retMeta.getPrimaryKey();
        if (uniqueKey == null) {
            return null;
        }
        return uniqueKey.key;
    }

    protected static Set<String> getDatabaseSharedingKeys(DispatcherResultImp retMeta) {
        List<ColumnMetaData> dbExpression = retMeta.getSplitDB();
        if (dbExpression == null || dbExpression.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> dbkeys = new HashSet<String>(dbExpression.size());
        for (ColumnMetaData col : dbExpression) {
            dbkeys.add(col.key);
        }
        return dbkeys;
    }

    public static void buildExecutePlan(DispatcherResult dispatcherResult, List<DatabaseExecutionContext> databaseExecutionContexts) {
        if (databaseExecutionContexts == null) {
            throw new IllegalArgumentException("targetDBList is null");
        }
        int size = databaseExecutionContexts.size();
        switch (size) {
            case 0: {
                dispatcherResult.setDatabaseExecutePlan(EXECUTE_PLAN.NONE);
                dispatcherResult.setTableExecutePlan(EXECUTE_PLAN.NONE);
                break;
            }
            case 1: {
                DatabaseExecutionContext targetDB = databaseExecutionContexts.get(0);
                List<Map<String, String>> set = targetDB.getTableNames();
                dispatcherResult.setTableExecutePlan(ControllerUtils.buildTableExecutePlan(set, null));
                if (dispatcherResult.getTableExecutePlan() != EXECUTE_PLAN.NONE) {
                    dispatcherResult.setDatabaseExecutePlan(EXECUTE_PLAN.SINGLE);
                    break;
                }
                dispatcherResult.setDatabaseExecutePlan(EXECUTE_PLAN.NONE);
                break;
            }
            default: {
                EXECUTE_PLAN currentExeutePlan = EXECUTE_PLAN.NONE;
                for (DatabaseExecutionContext oneDB : databaseExecutionContexts) {
                    currentExeutePlan = ControllerUtils.buildTableExecutePlan(oneDB.getTableNames(), currentExeutePlan);
                }
                dispatcherResult.setTableExecutePlan(currentExeutePlan);
                if (dispatcherResult.getTableExecutePlan() != EXECUTE_PLAN.NONE) {
                    dispatcherResult.setDatabaseExecutePlan(EXECUTE_PLAN.MULTIPLE);
                    break;
                }
                dispatcherResult.setDatabaseExecutePlan(EXECUTE_PLAN.NONE);
            }
        }
    }

    private static EXECUTE_PLAN buildTableExecutePlan(List<Map<String, String>> tableSet, EXECUTE_PLAN currentExecutePlan) {
        if (currentExecutePlan == null) {
            currentExecutePlan = EXECUTE_PLAN.NONE;
        }
        EXECUTE_PLAN tempExecutePlan = null;
        if (tableSet == null) {
            throw new IllegalStateException("targetTab is null");
        }
        int tableSize = tableSet.size();
        switch (tableSize) {
            case 0: {
                tempExecutePlan = EXECUTE_PLAN.NONE;
                break;
            }
            case 1: {
                tempExecutePlan = EXECUTE_PLAN.SINGLE;
                break;
            }
            default: {
                tempExecutePlan = EXECUTE_PLAN.MULTIPLE;
            }
        }
        return tempExecutePlan.value() > currentExecutePlan.value() ? tempExecutePlan : currentExecutePlan;
    }

    public static void appendTableSharedMetaData(Map<String, Comparative> mapList, DispatcherResultImp retMeta) {
        if (mapList == null) {
            return;
        }
        for (Map.Entry<String, Comparative> oneValue : mapList.entrySet()) {
            String uniqueColumnKey = ControllerUtils.getUniqueKey(retMeta);
            Set<String> dbSharedingKeys = ControllerUtils.getDatabaseSharedingKeys(retMeta);
            String sharedKey = ControllerUtils.toLowerCaseIgnoreNull(oneValue.getKey());
            if (sharedKey.equals(uniqueColumnKey) || dbSharedingKeys.contains(sharedKey)) continue;
            ColumnMetaData colMeta = new ColumnMetaData(sharedKey, oneValue.getValue());
            retMeta.addSplitTab(colMeta);
        }
    }

    public static void appendUniqueKeysMetaData(Map<String, Comparative> mapList, DispatcherResultImp retMeta) {
        if (mapList == null) {
            return;
        }
        for (Map.Entry<String, Comparative> oneValue : mapList.entrySet()) {
            String key = ControllerUtils.toLowerCaseIgnoreNull(oneValue.getKey());
            ColumnMetaData colMeta = new ColumnMetaData(key, oneValue.getValue());
            retMeta.setUniqueKey(colMeta);
        }
    }

    public static List<DatabaseExecutionContext> convertSingleTableTargetDBToDBExecutionContext(String logicTable, List<TargetDB> targetDBs) {
        ArrayList<DatabaseExecutionContextImp> databaseExecutionContexts = new ArrayList<DatabaseExecutionContextImp>(targetDBs.size());
        for (TargetDB targetDB : targetDBs) {
            DatabaseExecutionContextImp context = new DatabaseExecutionContextImp();
            context.setDbIndex(targetDB.getDbIndex());
            Set tableNames = targetDB.getTableNames();
            for (String realTable : tableNames) {
                HashMap<String, String> tablePair = new HashMap<String, String>(1, 1.0f);
                tablePair.put(logicTable, realTable);
                context.addTablePair(tablePair);
            }
            databaseExecutionContexts.add(context);
        }
        return null;
    }

    public static void buildReverseOutput(List<Object> args, SqlParserResult dmlc, DispatcherResult retMeta, boolean isMySQL) {
        int max = retMeta.getMax();
        int skip = retMeta.getSkip();
        boolean needRowCopy = retMeta.needRowCopy();
        List sqls = null;
        List<DatabaseExecutionContext> databaseExecutionContexts = retMeta.getDataBaseExecutionContexts();
        for (DatabaseExecutionContext databaseExecutionContext : databaseExecutionContexts) {
            HandlerContainer handler = new HandlerContainer();
            if (needRowCopy && dmlc instanceof Update) {
                if (isMySQL) {
                    handler.changeMySQLUpdateVersion();
                } else {
                    handler.changeOracleUpdateVersion();
                }
                retMeta.needAllowReverseOutput(true);
            }
            if (skip != -1000 && max != -1000) {
                EXECUTE_PLAN dbExecutionPlan = retMeta.getDatabaseExecutePlan();
                EXECUTE_PLAN tabExecutionPlan = retMeta.getTableExecutePlan();
                if (dbExecutionPlan.equals((Object)EXECUTE_PLAN.MULTIPLE) || tabExecutionPlan.equals((Object)EXECUTE_PLAN.MULTIPLE)) {
                    handler.changeRange((Number)0, (Number)max);
                    retMeta.needAllowReverseOutput(true);
                }
            }
            if (!retMeta.allowReverseOutput()) continue;
            handler.changeIndex();
            handler.changeTable();
            sqls = dmlc.getSqlReadyToRun(databaseExecutionContext.getTableNames(), args, handler);
            ArrayList<ReverseOutput> reverse = new ArrayList<ReverseOutput>(sqls.size());
            for (SqlAndTableAtParser sql : sqls) {
                ReverseOutput out = new ReverseOutput();
                out.setParams(sql.modifiedMap);
                out.setSql(sql.sql);
                out.setTable(sql.table.toString());
                reverse.add(out);
            }
            databaseExecutionContext.setOutputSQL(reverse);
        }
    }
}

