/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.controller;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.client.RouteCondition;
import com.taobao.tddl.client.dispatcher.DispatcherResult;
import com.taobao.tddl.client.dispatcher.Result;
import com.taobao.tddl.client.dispatcher.SingleLogicTableName;
import com.taobao.tddl.client.dispatcher.SqlDispatcher;
import com.taobao.tddl.client.dispatcher.impl.DatabaseAndTablesDispatcherResultImp;
import com.taobao.tddl.client.pipeline.PipelineFactory;
import com.taobao.tddl.client.pipeline.bootstrap.Bootstrap;
import com.taobao.tddl.client.pipeline.bootstrap.PipelineBootstrap;
import com.taobao.tddl.interact.rule.VirtualTable;
import com.taobao.tddl.interact.rule.VirtualTableRoot;
import com.taobao.tddl.parser.SQLParser;
import com.taobao.tddl.rule.bean.LogicTable;
import com.taobao.tddl.rule.bean.TDDLRoot;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpringBasedDispatcherImpl
implements SqlDispatcher {
    static final Log logger = LogFactory.getLog(SpringBasedDispatcherImpl.class);
    private SQLParser parser = null;
    TDDLRoot root;
    VirtualTableRoot vtabroot;
    private PipelineFactory pipelineFactory;
    private Bootstrap bootstrap;

    @Override
    public DispatcherResult getDBAndTables(RouteCondition rc) {
        if (null == this.bootstrap) {
            this.bootstrap = new PipelineBootstrap(null, this.pipelineFactory);
        }
        try {
            return this.bootstrap.bootstrapForGetDBAndTabs(rc, this);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public DispatcherResult getDBAndTables(String sql, List<Object> args) {
        if (null == this.bootstrap) {
            this.bootstrap = new PipelineBootstrap(null, this.pipelineFactory);
        }
        try {
            return this.bootstrap.bootstrapForGetDBAndTabs(sql, args, this);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public Result getAllDatabasesAndTables(String logicTableName) {
        if (this.root == null) {
            throw new RuntimeException("the root is null,may be use new rule,use getDbTopology may work!");
        }
        LogicTable logicTable = this.root.getLogicTable(StringUtil.toLowerCase((String)logicTableName));
        if (logicTable == null) {
            throw new IllegalArgumentException("\u903b\u8f91\u8868\u540d\u672a\u627e\u5230");
        }
        SingleLogicTableName log = new SingleLogicTableName(logicTableName);
        return new DatabaseAndTablesDispatcherResultImp(logicTable.getAllTargetDBList(), log);
    }

    @Override
    public Map<String, Set<String>> getDbTopology(String logicTableName) {
        if (this.vtabroot == null) {
            throw new RuntimeException("the vtabroot is null,may be use old rule, use getAllDatabasesAndTables may work!");
        }
        VirtualTable logicTable = (VirtualTable)this.vtabroot.getTableRules().get(logicTableName);
        return logicTable.getActualTopology();
    }

    @Override
    public SQLParser getParser() {
        return this.parser;
    }

    public void setParser(SQLParser parser) {
        this.parser = parser;
    }

    @Override
    public TDDLRoot getRoot() {
        return this.root;
    }

    public void setRoot(TDDLRoot root) {
        this.root = root;
    }

    @Override
    public VirtualTableRoot getVtabroot() {
        return this.vtabroot;
    }

    public void setVtabroot(VirtualTableRoot vtabroot) {
        this.vtabroot = vtabroot;
    }

    @Override
    public void setPipelineFactory(PipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }
}

