/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.dsmatrixcreator;

import com.taobao.tddl.client.jdbc.TddlRuntime;
import com.taobao.tddl.client.util.DataSourceType;
import com.taobao.tddl.common.ConfigServerHelper;
import com.taobao.tddl.common.DataSourceChangeListener;
import com.taobao.tddl.common.config.ConfigDataHandler;
import com.taobao.tddl.common.config.ConfigDataHandlerFactory;
import com.taobao.tddl.common.config.ConfigDataListener;
import com.taobao.tddl.common.config.impl.DefaultConfigDataHandlerFactory;
import com.taobao.tddl.jdbc.group.TGroupDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceMatrixCreatorImp
implements ConfigDataListener {
    Log logger = LogFactory.getLog(DataSourceMatrixCreatorImp.class);
    private volatile TddlRuntime matrixDSRuntime = new TddlRuntime(Collections.EMPTY_MAP);
    private volatile ConfigDataHandlerFactory cdhf;
    private String appName;
    private DataSourceType dataSourceType;
    private ConfigDataHandler matrixHandler;
    private final List<DataSourceChangeListener> dsChangeListeners = new ArrayList<DataSourceChangeListener>(2);

    public DataSourceMatrixCreatorImp() {
    }

    public DataSourceMatrixCreatorImp(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public synchronized void setNewDSMatrixKey(String appName) {
        String data;
        this.setAppName(appName);
        this.logger.warn((Object)("receive a ds keys,follow will add to map " + appName));
        String configKey = ConfigServerHelper.getDBGroupsConfig((String)this.appName);
        this.cdhf = new DefaultConfigDataHandlerFactory();
        this.matrixHandler = this.cdhf.getConfigDataHandler(configKey, (ConfigDataListener)this);
        try {
            data = this.matrixHandler.getData(10000L, "firstCache");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (data == null) {
            throw new RuntimeException("can't find datasource map by appName :" + appName);
        }
        this.appendNewDataSourceMap(data);
        this.logger.warn((Object)"success");
    }

    private Set<String> getKey2Add(String[] tempArray, Set<String> oldHaveNewDont) {
        HashSet<String> newKeyToAdd = new HashSet<String>(Arrays.asList(tempArray));
        HashSet<String> tempOldHaveNewDont = new HashSet<String>(oldHaveNewDont);
        for (String temp : tempArray) {
            if (temp == null || temp.length() == 0 || !tempOldHaveNewDont.contains(temp)) continue;
            tempOldHaveNewDont.remove(temp);
            newKeyToAdd.remove(temp);
        }
        if (!tempOldHaveNewDont.isEmpty()) {
            throw new IllegalArgumentException("only add is allowed" + tempOldHaveNewDont);
        }
        return newKeyToAdd;
    }

    private Map<String, DataSource> getNewDataSourceMap(Set<String> new2add) {
        HashMap<String, DataSource> newDsMap = new HashMap<String, DataSource>(new2add.size());
        if (new2add.isEmpty()) {
            return newDsMap;
        }
        for (String key : new2add) {
            this.logger.warn((Object)("add a ds 2 map. key is " + key));
            TGroupDataSource tgroupds = new TGroupDataSource();
            tgroupds.setDbGroupKey(key);
            tgroupds.setDataSourceType(this.dataSourceType);
            tgroupds.setAppName(this.getAppName());
            tgroupds.init();
            newDsMap.put(key, (DataSource)tgroupds);
        }
        this.logger.warn((Object)"inited");
        return newDsMap;
    }

    public void appendNewDataSourceMap(String data) {
        this.logger.warn((Object)("received data " + data));
        String[] keys = DataSourceMatrixCreatorImp.propertiesSpliter(data);
        if (keys == null) {
            this.logger.warn((Object)"keys is null ,do nothing");
            return;
        }
        Set<String> oldSet = this.matrixDSRuntime.dsMap.keySet();
        Set<String> new2AddSet = this.getKey2Add(keys, oldSet);
        Map<String, DataSource> newDSMap = this.getNewDataSourceMap(new2AddSet);
        Map<String, DataSource> oldDSMap = this.matrixDSRuntime.dsMap;
        newDSMap.putAll(oldDSMap);
        this.matrixDSRuntime = new TddlRuntime(newDSMap);
        this.logger.warn((Object)"matrix refresh!");
    }

    public synchronized void onDataRecieved(String dataId, String data) {
        this.logger.warn((Object)("matrix ds data received !dataId:" + dataId + " data:" + data));
        this.appendNewDataSourceMap(data);
        for (DataSourceChangeListener dataSourceChangeListener : this.dsChangeListeners) {
            dataSourceChangeListener.onDataSourceChanged(this.matrixDSRuntime.dsMap);
        }
    }

    public void addPropertiesChangeListener(DataSourceChangeListener dataSourceChangeListener) {
        this.dsChangeListeners.add(dataSourceChangeListener);
    }

    public Map<String, DataSource> getDataSourceMap() {
        if (this.matrixDSRuntime == null) {
            throw new IllegalArgumentException("not inited");
        }
        return this.matrixDSRuntime.dsMap;
    }

    public synchronized void setDSMatrixeKey(String key) {
        String[] tempArray = DataSourceMatrixCreatorImp.propertiesSpliter(key);
        if (tempArray == null) {
            throw new IllegalArgumentException("input new dsMartrix is null");
        }
        if (this.matrixDSRuntime != null) {
            throw new IllegalArgumentException("already have matrixDS runtime");
        }
        this.logger.warn((Object)"init a new ds");
        HashSet<String> keySet = new HashSet<String>();
        HashMap<String, ConfigDataHandler> newMap = new HashMap<String, ConfigDataHandler>();
        for (String str : tempArray) {
            ConfigDataHandler cdh = this.cdhf.getConfigDataHandler(str, (ConfigDataListener)this);
            newMap.put(str, cdh);
            String data = cdh.getData(10000L, "firstCache");
            keySet.addAll(Arrays.asList(DataSourceMatrixCreatorImp.propertiesSpliter(data)));
        }
        Map<String, DataSource> dsMap = this.getNewDataSourceMap(keySet);
        this.matrixDSRuntime = new TddlRuntime(dsMap);
        this.logger.warn((Object)"success");
    }

    public ConfigDataHandlerFactory getCdhf() {
        return this.cdhf;
    }

    public synchronized void setCdhf(ConfigDataHandlerFactory cdhf) {
        this.cdhf = cdhf;
    }

    public String getAppName() {
        return this.appName;
    }

    protected void setAppName(String appName) {
        if (this.appName != null) {
            if (!appName.equals(this.appName)) {
                throw new IllegalArgumentException("already have appName !" + appName);
            }
            this.logger.warn((Object)("set app name twice. " + appName));
        }
        this.appName = appName;
    }

    public ConfigDataHandler getMatrixHandler() {
        return this.matrixHandler;
    }

    public static String[] propertiesSpliter(String target) {
        if (target == null) {
            return null;
        }
        String[] tokens = target.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public void destroyAll() {
        if (this.matrixHandler != null) {
            this.matrixHandler.closeUnderManager();
        }
        Map<String, DataSource> map = this.matrixDSRuntime.dsMap;
        for (DataSource ds : map.values()) {
            if (!(ds instanceof TGroupDataSource)) continue;
            try {
                ((TGroupDataSource)ds).destroyDataSource();
            }
            catch (Exception e) {
                this.logger.error((Object)"we got exception when close .", (Throwable)e);
            }
        }
    }
}

