/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.handler;

import com.taobao.eagleeye.EagleEye;
import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.handler.Handler;
import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.common.SQLPreParser;
import com.taobao.tddl.parser.ParserCache;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHandler
implements Handler {
    public static final String ALL_PERF_TABLE_PREFIX = "__test_";
    protected static final Log sqlLog = LogFactory.getLog((String)"TDDL_SQL_LOG");
    protected static final ParserCache globalCache = ParserCache.instance();

    protected PipelineRuntimeInfo getPipeLineRuntimeInfo(DataBus dataBus) {
        return (PipelineRuntimeInfo)dataBus.getPluginContext("PipelineRuntimeInfo");
    }

    protected void debugLog(Log log, Object[] contents) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.getLogStr(contents));
        }
    }

    protected void infoLog(Log log, Object[] contents) {
        if (log.isInfoEnabled()) {
            log.info((Object)this.getLogStr(contents));
        }
    }

    protected void warnLog(Log log, Object[] contents) {
        if (log.isWarnEnabled()) {
            log.warn((Object)this.getLogStr(contents));
        }
    }

    protected void errorLog(Log log, Object[] contents) {
        if (log.isErrorEnabled()) {
            log.error((Object)this.getLogStr(contents));
        }
    }

    private String getLogStr(Object[] contents) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : contents) {
            sb.append(String.valueOf(obj));
        }
        return sb.toString();
    }

    protected boolean getUseParallelFromThreadLocal() {
        Object obj = ThreadLocalMap.get((Object)"PARALLEL_EXECUTE");
        boolean useParallel = false;
        if (null != obj) {
            useParallel = (Boolean)obj;
            ThreadLocalMap.put((Object)"PARALLEL_EXECUTE", null);
        }
        return useParallel;
    }

    public String replaceTableName(String originalSql, String virtualName, String actualName, Log log) {
        boolean padding = false;
        if (log.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("virtualName = ").append(virtualName).append(", ");
            buffer.append("actualName = ").append(actualName);
            log.debug((Object)buffer.toString());
        }
        String t = EagleEye.getUserData((String)"t");
        if (virtualName.equalsIgnoreCase(actualName) && (StringUtils.isBlank((String)t) || !t.equals("1"))) {
            return originalSql;
        }
        List sqlPieces = globalCache.getTableNameReplacement(originalSql);
        if (sqlPieces == null) {
            List pieces1 = this.parseAPattern_begin(virtualName, originalSql, "\\s" + virtualName + "$", padding);
            pieces1 = this.parseAPattern(virtualName, pieces1, "\\s" + virtualName + "\\s", padding);
            pieces1 = this.parseAPattern(virtualName, pieces1, "." + virtualName + "\\.", padding);
            pieces1 = this.parseAPattern(virtualName, pieces1, "\\s" + virtualName + "\\(", padding);
            pieces1 = this.parseAPatternByCalcTable(virtualName, pieces1, "//*+.*" + "_" + virtualName + "_" + ".*/*/", padding);
            pieces1 = this.parseAPattern(virtualName, pieces1, "\\s" + virtualName + "\\,", padding);
            pieces1 = this.parseAPattern(virtualName, pieces1, "\\," + virtualName + "\\s", padding);
            sqlPieces = pieces1 = this.parseAPattern(virtualName, pieces1, "\\," + virtualName + "\\,", padding);
            sqlPieces = globalCache.setTableNameReplacementIfAbsent(originalSql, sqlPieces);
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Object piece : sqlPieces) {
            if (!(piece instanceof String)) {
                throw new IllegalArgumentException("should not be here ! table is " + piece);
            }
            if (!first) {
                if (!StringUtils.isBlank((String)t) && t.equals("1")) {
                    buffer.append(ALL_PERF_TABLE_PREFIX);
                }
                buffer.append(actualName);
            } else {
                first = false;
            }
            buffer.append(piece);
        }
        return buffer.toString();
    }

    protected List<Object> parseAPattern_begin(String virtualName, String originalSql, String pattern, boolean padding) {
        Pattern pattern1 = Pattern.compile(pattern, 2);
        LinkedList<Object> pieces1 = new LinkedList<Object>();
        Matcher matcher1 = pattern1.matcher(originalSql);
        int start1 = 0;
        while (matcher1.find(start1)) {
            pieces1.add(originalSql.substring(start1, matcher1.start() + 1));
            start1 = matcher1.end();
            if (!padding) continue;
            pieces1.add(new LogicTable(virtualName));
        }
        pieces1.add(originalSql.substring(start1));
        return pieces1;
    }

    protected List<Object> parseAPatternByCalcTable(String virtualName, List<Object> pieces, String pattern, boolean padding) {
        LinkedList<Object> pieces2 = new LinkedList<Object>();
        for (Object piece : pieces) {
            if (piece instanceof String) {
                String strpiece = (String)piece;
                Pattern pattern2 = Pattern.compile(pattern, 2);
                Matcher matcher2 = pattern2.matcher(strpiece);
                int start2 = 0;
                while (matcher2.find(start2)) {
                    int tableNameStart = matcher2.group().toUpperCase().indexOf(virtualName.toUpperCase()) + matcher2.start();
                    int tableNameEnd = tableNameStart + virtualName.length();
                    pieces2.add(strpiece.substring(start2, tableNameStart));
                    start2 = tableNameEnd;
                    if (!padding) continue;
                    pieces2.add(new LogicTable(virtualName));
                }
                pieces2.add(strpiece.substring(start2));
                continue;
            }
            pieces2.add(piece);
        }
        return pieces2;
    }

    protected List<Object> parseAPattern(String virtualName, List<Object> pieces, String pattern, boolean padding) {
        LinkedList<Object> pieces2 = new LinkedList<Object>();
        for (Object piece : pieces) {
            if (piece instanceof String) {
                String strpiece = (String)piece;
                Pattern pattern2 = Pattern.compile(pattern, 2);
                Matcher matcher2 = pattern2.matcher(strpiece);
                int start2 = 0;
                while (matcher2.find(start2)) {
                    pieces2.add(strpiece.substring(start2 - 1 < 0 ? 0 : start2 - 1, matcher2.start() + 1));
                    start2 = matcher2.end();
                    if (!padding) continue;
                    pieces2.add(new LogicTable(virtualName));
                }
                pieces2.add(strpiece.substring(start2 - 1 < 0 ? 0 : start2 - 1));
                continue;
            }
            pieces2.add(piece);
        }
        return pieces2;
    }

    protected String replcaeMultiTableName(String originalSql, Map<String, String> tableToBeReplaced) {
        Iterator<Map.Entry<String, String>> i$;
        boolean padding = true;
        if (sqlLog.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("table  = ").append(tableToBeReplaced).append(", ");
            sqlLog.debug((Object)buffer.toString());
        }
        if (tableToBeReplaced.size() == 0) {
            String t = EagleEye.getUserData((String)"t");
            if (!StringUtils.isBlank((String)t) && t.equals("1")) {
                String firstTable = SQLPreParser.findTableName((String)originalSql);
                return this.replaceTableName(originalSql, firstTable, firstTable, sqlLog);
            }
            return originalSql;
        }
        if (tableToBeReplaced.size() == 1 && (i$ = tableToBeReplaced.entrySet().iterator()).hasNext()) {
            Map.Entry<String, String> entry = i$.next();
            return this.replaceTableName(originalSql, entry.getKey(), entry.getValue(), sqlLog);
        }
        List<Object> sqlPieces = globalCache.getTableNameReplacement(originalSql);
        if (sqlPieces == null) {
            for (Map.Entry<String, String> entry : tableToBeReplaced.entrySet()) {
                String string = entry.getKey();
                sqlPieces = sqlPieces == null ? this.parseAPattern_begin(string, originalSql, "\\s" + string + "$", padding) : this.parseAPattern(string, sqlPieces, "\\s" + string + "$", padding);
                sqlPieces = this.parseAPattern(string, sqlPieces, "\\s" + string + "\\s", padding);
                sqlPieces = this.parseAPattern(string, sqlPieces, "." + string + "\\.", padding);
                sqlPieces = this.parseAPattern(string, sqlPieces, "\\s" + string + "\\(", padding);
                sqlPieces = this.parseAPatternByCalcTable(string, sqlPieces, "//*+.*" + "_" + string + "_" + ".*/*/", padding);
                sqlPieces = this.parseAPattern(string, sqlPieces, "\\s" + string + "\\,", padding);
                sqlPieces = this.parseAPattern(string, sqlPieces, "\\," + string + "\\s", padding);
                sqlPieces = this.parseAPattern(string, sqlPieces, "\\," + string + "\\,", padding);
            }
            sqlPieces = globalCache.setTableNameReplacementIfAbsent(originalSql, (List)sqlPieces);
        }
        StringBuilder buffer = new StringBuilder();
        for (Object e : sqlPieces) {
            if (e instanceof String) {
                buffer.append(e);
                continue;
            }
            if (!(e instanceof LogicTable)) continue;
            String t = EagleEye.getUserData((String)"t");
            if (!StringUtils.isBlank((String)t) && t.equals("1")) {
                buffer.append(ALL_PERF_TABLE_PREFIX);
            }
            buffer.append(tableToBeReplaced.get(((LogicTable)e).logictable));
        }
        return buffer.toString();
    }

    public static enum FlowType {
        DIRECT,
        NOSQLPARSE,
        DEFAULT,
        BATCH,
        BATCH_DIRECT,
        BATCH_NOSQLPARSER,
        DBANDTAB_RC,
        DBANDTAB_SQL;

    }

    static class LogicTable {
        public String logictable;

        public LogicTable(String logicTable) {
            this.logictable = logicTable;
        }

        public String toString() {
            return "logictable:" + this.logictable;
        }
    }
}

