/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.handler.executionplan;

import com.taobao.tddl.client.controller.DatabaseExecutionContext;
import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.dispatcher.DispatcherResult;
import com.taobao.tddl.client.handler.AbstractHandler;
import com.taobao.tddl.common.jdbc.ParameterContext;
import com.taobao.tddl.interact.bean.TargetDB;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchTargetSqlHandler
extends AbstractHandler {
    public static final String HANDLER_NAME = "BatchTargetSqlHandler";
    private static final Log log = LogFactory.getLog(BatchTargetSqlHandler.class);

    @Override
    public void handleDown(DataBus dataBus) throws SQLException {
        AbstractHandler.FlowType flowType = this.getPipeLineRuntimeInfo(dataBus).getFlowType();
        if (AbstractHandler.FlowType.BATCH_DIRECT == flowType || AbstractHandler.FlowType.BATCH == flowType || AbstractHandler.FlowType.BATCH_NOSQLPARSER == flowType) {
            this.makeUp(dataBus);
        }
    }

    public void makeUp(DataBus dataBus) throws SQLException {
        PipelineRuntimeInfo runtime = super.getPipeLineRuntimeInfo(dataBus);
        DirectlyRouteCondition directlyRouteCondition = runtime.getStartInfo().getDirectlyRouteCondition();
        String sql = runtime.getStartInfo().getSql();
        boolean isParameterBatch = runtime.getStartInfo().isParameterBatch();
        if (directlyRouteCondition != null) {
            if (isParameterBatch) {
                this.targetSqlWithParameterDirect(directlyRouteCondition, sql, runtime);
            } else {
                this.targetSqlWithOutParameterDirect(directlyRouteCondition, sql, runtime);
            }
        } else {
            DispatcherResult dispatcherResult = runtime.getMetaData();
            if (isParameterBatch) {
                this.targetSqlWithParameter(dispatcherResult, sql, runtime);
            } else {
                this.targetSqlWithOutParameter(dispatcherResult, sql, runtime);
            }
        }
    }

    private void targetSqlWithParameterDirect(DirectlyRouteCondition conditon, String sql, PipelineRuntimeInfo runtime) {
        List<List<ParameterContext>> paramsList;
        String dbId;
        Map<String, Map<String, List<List<ParameterContext>>>> targetSqls = runtime.getStartInfo().getTargetSqls();
        Map<String, List<List<ParameterContext>>> sqls = targetSqls.get(dbId = conditon.getDbRuleID());
        if (sqls == null) {
            sqls = new HashMap<String, List<List<ParameterContext>>>();
            targetSqls.put(dbId, sqls);
        }
        if ((paramsList = sqls.get(sql)) == null) {
            paramsList = new ArrayList<List<ParameterContext>>();
            sqls.put(sql, paramsList);
        }
        paramsList.add(this.getBatchParametersList(runtime.getStartInfo().getSqlParam()));
    }

    private void targetSqlWithOutParameterDirect(DirectlyRouteCondition conditon, String sql, PipelineRuntimeInfo runtime) {
        Map<String, List<String>> targetSqls = runtime.getStartInfo().getTargetSqlsNoParameter();
        List<String> sqlList = targetSqls.get(conditon.getDbRuleID());
        if (sqlList == null) {
            sqlList = new ArrayList<String>();
            targetSqls.put(conditon.getDbRuleID(), sqlList);
        }
        sqlList.add(sql);
    }

    public void targetSqlWithParameter(DispatcherResult dispatcherResult, String sql, PipelineRuntimeInfo runtime) {
        Map<String, Map<String, List<List<ParameterContext>>>> targetSqls = runtime.getStartInfo().getTargetSqls();
        List<TargetDB> targets = dispatcherResult.getTarget();
        String virtualTableName = dispatcherResult.getVirtualTableName().toString();
        for (TargetDB target : targets) {
            String targetName = target.getDbIndex();
            if (!targetSqls.containsKey(targetName)) {
                targetSqls.put(targetName, new HashMap());
            }
            Map<String, List<List<ParameterContext>>> sqls = targetSqls.get(targetName);
            Set actualTables = target.getTableNames();
            int i = 0;
            for (String tab : actualTables) {
                String targetSql = this.replaceTableName(sql, virtualTableName, tab, log);
                if (!sqls.containsKey(targetSql)) {
                    ArrayList paramsList = new ArrayList();
                    sqls.put(targetSql, paramsList);
                }
                sqls.get(targetSql).add(this.getBatchParametersList(runtime.getStartInfo().getSqlParam()));
                ++i;
            }
        }
    }

    public void targetSqlWithOutParameter(DispatcherResult dispatcherResult, String sql, PipelineRuntimeInfo runtime) {
        List<DatabaseExecutionContext> targets = dispatcherResult.getDataBaseExecutionContexts();
        Map<String, List<String>> targetSqls = runtime.getStartInfo().getTargetSqlsNoParameter();
        for (DatabaseExecutionContext target : targets) {
            String targetName = target.getDbIndex();
            if (!targetSqls.containsKey(targetName)) {
                targetSqls.put(targetName, new ArrayList(8));
            }
            List<String> sqls = targetSqls.get(targetName);
            List<Map<String, String>> actualTables = target.getTableNames();
            for (Map<String, String> tab : actualTables) {
                String targetSql = this.replcaeMultiTableName(sql, tab);
                sqls.add(targetSql);
            }
        }
    }

    public List<ParameterContext> getBatchParametersList(Map<Integer, ParameterContext> parameterSettings) {
        ArrayList<ParameterContext> batchedParameterSettings = new ArrayList<ParameterContext>();
        for (ParameterContext context : parameterSettings.values()) {
            batchedParameterSettings.add(context);
        }
        return batchedParameterSettings;
    }
}

