/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.handler.executionplan;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.client.controller.DatabaseExecutionContext;
import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.dispatcher.DispatcherResult;
import com.taobao.tddl.client.dispatcher.SqlDispatcher;
import com.taobao.tddl.client.handler.AbstractHandler;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.RealSqlContextImp;
import com.taobao.tddl.client.jdbc.SqlExecuteEvent;
import com.taobao.tddl.client.jdbc.SqlExecuteEventUtil;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlanImp;
import com.taobao.tddl.common.jdbc.ParameterContext;
import com.taobao.tddl.common.jdbc.ParameterMethod;
import com.taobao.tddl.interact.bean.Field;
import com.taobao.tddl.interact.bean.ReverseOutput;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.sqlobjecttree.InExpressionObject;
import com.taobao.tddl.sqlobjecttree.SqlParserResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecutionPlanHandler
extends AbstractHandler {
    public static final String HANDLER_NAME = "ExecutionPlanHandler";
    private static final Log log = LogFactory.getLog(ExecutionPlanHandler.class);
    private static String patternStr = "in\\s*\\((\\s*\\?\\s*)?(,\\s*\\?\\s*)*\\)\\s*";
    private static Pattern inpattern = Pattern.compile(patternStr);

    @Override
    public void handleDown(DataBus dataBus) throws SQLException {
        if (AbstractHandler.FlowType.DEFAULT == this.getPipeLineRuntimeInfo(dataBus).getFlowType() || AbstractHandler.FlowType.NOSQLPARSE == this.getPipeLineRuntimeInfo(dataBus).getFlowType()) {
            this.makeUp(dataBus);
        }
    }

    private void makeUp(DataBus dataBus) throws SQLException {
        PipelineRuntimeInfo runtime = super.getPipeLineRuntimeInfo(dataBus);
        List<String> virtualJoinTableNames = runtime.getVirtualJoinTableNames();
        DispatcherResult metaData = runtime.getMetaData();
        boolean isAutoCommit = runtime.getStartInfo().isAutoCommit();
        Map<Integer, ParameterContext> parameterSettings = runtime.getStartInfo().getSqlParam();
        SqlDispatcher sqlDispatcher = runtime.getSqlDispatcher();
        String originalSql = runtime.getStartInfo().getSql();
        SqlType sqlType = runtime.getStartInfo().getSqlType();
        boolean needRowCopy = runtime.isNeedRowCopy();
        SqlParserResult spr = runtime.getSqlParserResult();
        boolean needIdInGroup = runtime.isNeedIdInGroup();
        metaData.setVirtualJoinTableNames(virtualJoinTableNames);
        List<DatabaseExecutionContext> targets = metaData.getDataBaseExecutionContexts();
        ExecutionPlanImp executionPlan = new ExecutionPlanImp();
        if (targets == null || targets.isEmpty()) {
            throw new SQLException("\u627e\u4e0d\u5230\u76ee\u6807\u5e93\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        this.buildExecutionContext(originalSql, executionPlan, sqlType, metaData, targets, sqlDispatcher, parameterSettings, isAutoCommit, needRowCopy, spr, needIdInGroup);
        executionPlan.setUseParallel(this.getUseParallelFromThreadLocal());
        this.setResult(executionPlan, runtime);
        this.debugLog(log, new Object[]{"sql dispatch end."});
    }

    private void buildExecutionContext(String originalSql, ExecutionPlanImp executionPlanImp, SqlType sqlType, DispatcherResult metaData, List<DatabaseExecutionContext> targets, SqlDispatcher sqlDispatcher, Map<Integer, ParameterContext> parameterSettings, boolean isAutoCommit, boolean needRowCopy, SqlParserResult spr, boolean needIdInGroup) throws SQLException {
        int size = targets.size();
        HashMap<String, List<RealSqlContext>> sqlMap = new HashMap<String, List<RealSqlContext>>(size);
        for (DatabaseExecutionContext target : targets) {
            String dbSelectorId = target.getDbIndex();
            List<Map<String, String>> actualTables = target.getTableNames();
            this.printLog(dbSelectorId, actualTables);
            if (dbSelectorId == null || dbSelectorId.length() < 1) {
                throw new SQLException("invalid dbSelectorId:" + dbSelectorId);
            }
            if (actualTables == null || actualTables.isEmpty()) {
                throw new SQLException("\u627e\u4e0d\u5230\u76ee\u6807\u8868");
            }
            List<RealSqlContext> sqlContext = null;
            if (needIdInGroup && spr.getInExpressionObjectList().size() == 1) {
                this.debugLog(log, new Object[]{"use id in group!columnName:", ((InExpressionObject)spr.getInExpressionObjectList().get((int)0)).columnName});
                sqlContext = this.buildDBRealSqlContextWithInReplace(originalSql, metaData, parameterSettings, target, (InExpressionObject)spr.getInExpressionObjectList().get(0));
            } else {
                sqlContext = this.buildDBRealSqlContext(originalSql, metaData, parameterSettings, target);
            }
            sqlMap.put(dbSelectorId, sqlContext);
        }
        executionPlanImp.setSqlMap(sqlMap);
        executionPlanImp.setOriginalArgs(parameterSettings);
        executionPlanImp.setOrderByColumns(metaData.getOrderByMessages().getOrderbyList());
        executionPlanImp.setSkip(metaData.getSkip() == -1000 ? 0 : metaData.getSkip());
        executionPlanImp.setMax(metaData.getMax() == -1000 ? -1 : metaData.getMax());
        executionPlanImp.setGroupFunctionType(metaData.getGroupFunctionType());
        executionPlanImp.setVirtualTableName(metaData.getVirtualTableName());
        executionPlanImp.setEvents(this.createEvent(metaData, sqlType, originalSql, needRowCopy));
        boolean goSlave = SqlType.SELECT.equals((Object)sqlType);
        executionPlanImp.setGoSlave(goSlave);
        executionPlanImp.setOriginalSql(originalSql);
        executionPlanImp.setDistinctColumns(metaData.getDistinctColumns());
    }

    private List<RealSqlContext> buildDBRealSqlContext(String originalSql, DispatcherResult metaData, Map<Integer, ParameterContext> parameterSettings, DatabaseExecutionContext target) throws SQLException {
        ArrayList<RealSqlContext> sqlContext = new ArrayList<RealSqlContext>(target.getTableNames().size());
        List<Map<String, String>> actualTables = target.getTableNames();
        if (actualTables == null || actualTables.isEmpty()) {
            throw new SQLException("\u627e\u4e0d\u5230\u76ee\u6807\u8868");
        }
        if (!metaData.allowReverseOutput()) {
            for (Map<String, String> tab : actualTables) {
                RealSqlContextImp realSqlContext = new RealSqlContextImp();
                sqlContext.add(realSqlContext);
                String sql = this.replcaeMultiTableName(originalSql, tab);
                realSqlContext.setRealTable(tab.values().toString());
                realSqlContext.setSql(sql);
                realSqlContext.setArgument(parameterSettings);
                this.debugLog(log, new Object[]{"use table replace,one of final to be executed sql is:", sql, ";final parameter is:", parameterSettings});
            }
        } else {
            List<ReverseOutput> sqlInfos = target.getOutputSQL();
            if (sqlInfos == null || sqlInfos.isEmpty()) {
                throw new SQLException("\u627e\u4e0d\u5230\u76ee\u6807\u8868");
            }
            Map changedParameters = sqlInfos.get(0).getParams();
            this.changeParameters(changedParameters, parameterSettings);
            for (ReverseOutput sqlInfo : sqlInfos) {
                RealSqlContextImp realSqlContext = new RealSqlContextImp();
                sqlContext.add(realSqlContext);
                realSqlContext.setSql(sqlInfo.getSql());
                realSqlContext.setRealTable(sqlInfo.getTable());
                realSqlContext.setArgument(parameterSettings);
                this.debugLog(log, new Object[]{"use reverse output,one of final to be executed sql is:", sqlInfo.getSql(), ";final parameter is:", parameterSettings});
            }
        }
        return sqlContext;
    }

    private List<RealSqlContext> buildDBRealSqlContextWithInReplace(String originalSql, DispatcherResult metaData, Map<Integer, ParameterContext> parameterSettings, DatabaseExecutionContext target, InExpressionObject in) throws SQLException {
        ArrayList<RealSqlContext> sqlContext = new ArrayList<RealSqlContext>(target.getTableNames().size());
        List<Map<String, String>> actualTables = target.getTableNames();
        if (actualTables == null || actualTables.isEmpty()) {
            throw new SQLException("\u627e\u4e0d\u5230\u76ee\u6807\u8868");
        }
        if (!metaData.allowReverseOutput()) {
            for (Map<String, String> tab : actualTables) {
                RealSqlContextImp realSqlContext = new RealSqlContextImp();
                sqlContext.add(realSqlContext);
                String sql = this.replcaeMultiTableName(originalSql, tab);
                Map<Integer, ParameterContext> replacedParameterSettings = parameterSettings;
                if (in.bindVarIndexs != null) {
                    sql = this.changePrepareStatementSql(sql, StringUtil.substringBetween((String)tab.values().toString(), (String)"[", (String)"]"), target.getRealTableFieldMap(), in);
                    replacedParameterSettings = this.changeParameterContext(parameterSettings, StringUtil.substringBetween((String)tab.values().toString(), (String)"[", (String)"]"), target.getRealTableFieldMap(), in);
                }
                realSqlContext.setRealTable(tab.values().toString());
                realSqlContext.setSql(sql);
                realSqlContext.setArgument(replacedParameterSettings);
                this.debugLog(log, new Object[]{"use table replace,one of final to be executed sql is:", sql, ";final parameter is:", replacedParameterSettings});
            }
        } else {
            List<ReverseOutput> sqlInfos = target.getOutputSQL();
            if (sqlInfos == null || sqlInfos.isEmpty()) {
                throw new SQLException("\u627e\u4e0d\u5230\u76ee\u6807\u8868");
            }
            Map changedParameters = sqlInfos.get(0).getParams();
            this.changeParameters(changedParameters, parameterSettings);
            for (ReverseOutput sqlInfo : sqlInfos) {
                Map<Integer, ParameterContext> replacedParameterSettings = parameterSettings;
                String sql = sqlInfo.getSql();
                if (in.bindVarIndexs != null) {
                    sql = this.changePrepareStatementSql(sqlInfo.getSql(), this.getReverseOutPutRealTable(sqlInfo.getTable()), target.getRealTableFieldMap(), in);
                    replacedParameterSettings = this.changeParameterContext(parameterSettings, this.getReverseOutPutRealTable(sqlInfo.getTable()), target.getRealTableFieldMap(), in);
                }
                RealSqlContextImp realSqlContext = new RealSqlContextImp();
                sqlContext.add(realSqlContext);
                realSqlContext.setSql(sql);
                realSqlContext.setRealTable(sqlInfo.getTable());
                realSqlContext.setArgument(replacedParameterSettings);
                this.debugLog(log, new Object[]{"use reverse output,one of final to be executed sql is:", sql, ";final parameter is:", replacedParameterSettings});
            }
        }
        return sqlContext;
    }

    private String getReverseOutPutRealTable(String tableMapStr) {
        String str = StringUtil.substringBetween((String)tableMapStr, (String)"{", (String)"}");
        return StringUtil.split((String)str, (String)"=")[1];
    }

    private String changePrepareStatementSql(String sql, String realTable, Map<String, Field> filedMap, InExpressionObject in) throws SQLException {
        Field f = filedMap.get(realTable);
        if (null == f || f.equals(Field.EMPTY_FIELD)) {
            return sql;
        }
        Set sourceValues = (Set)f.sourceKeys.get(in.columnName.toUpperCase());
        if (null == sourceValues) {
            return sql;
        }
        String[] sqlPieces = inpattern.split(sql.toLowerCase());
        StringBuilder replacedSql = new StringBuilder();
        if (null != sqlPieces && sqlPieces.length == 1) {
            this.appendPrepareStatementSql(replacedSql, sqlPieces, sourceValues.size());
        } else if (null != sqlPieces && sqlPieces.length == 2) {
            this.appendPrepareStatementSql(replacedSql, sqlPieces, sourceValues.size());
            replacedSql.append(sqlPieces[1]);
        } else {
            return sql;
        }
        return replacedSql.toString();
    }

    private void appendPrepareStatementSql(StringBuilder sb, String[] sqlPieces, int size) {
        sb.append(sqlPieces[0]);
        sb.append(" in (");
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                sb.append("?");
                continue;
            }
            sb.append("?,");
        }
        sb.append(") ");
    }

    /*
     * WARNING - void declaration
     */
    private Map<Integer, ParameterContext> changeParameterContext(Map<Integer, ParameterContext> parameterSettings, String realTable, Map<String, Field> filedMap, InExpressionObject in) throws SQLException {
        void var12_17;
        Field f = filedMap.get(realTable);
        if (null == f || f.equals(Field.EMPTY_FIELD)) {
            return parameterSettings;
        }
        Set sourceValues = (Set)f.sourceKeys.get(in.columnName.toUpperCase());
        if (null == sourceValues) {
            return parameterSettings;
        }
        List bindVarIndexs = in.bindVarIndexs;
        HashMap<Integer, ParameterContext> re = new HashMap<Integer, ParameterContext>();
        TreeMap<Integer, Object> tempMap = new TreeMap<Integer, Object>();
        int count = 0;
        block0: for (Integer n : bindVarIndexs) {
            ParameterContext pc = parameterSettings.get(n + 1);
            Object obj = pc.getArgs()[1];
            for (Object s : sourceValues) {
                if (!s.equals(obj)) continue;
                tempMap.put((Integer)bindVarIndexs.get(count) + 1, pc);
                ++count;
                continue block0;
            }
        }
        for (Map.Entry entry : parameterSettings.entrySet()) {
            if (bindVarIndexs.contains((Integer)entry.getKey() - 1)) continue;
            tempMap.put((Integer)entry.getKey(), entry.getValue());
        }
        int tempMapSize = tempMap.size();
        boolean bl = false;
        while (var12_17 < tempMapSize) {
            Integer ind = (Integer)tempMap.firstKey();
            ParameterContext pc = (ParameterContext)tempMap.get(ind);
            ParameterContext ele = new ParameterContext();
            ele.setParameterMethod(pc.getParameterMethod());
            ele.setArgs(new Object[2]);
            ele.getArgs()[0] = (int)(var12_17 + true);
            ele.getArgs()[1] = pc.getArgs()[1];
            re.put((int)(var12_17 + true), ele);
            tempMap.remove(ind);
            ++var12_17;
        }
        return re;
    }

    private void changeParameters(Map<Integer, Object> changedParameters, Map<Integer, ParameterContext> parameterSettings) {
        for (Map.Entry<Integer, Object> entry : changedParameters.entrySet()) {
            ParameterContext context = parameterSettings.get(entry.getKey() + 1);
            if (context.getParameterMethod() == ParameterMethod.setNull1 || context.getParameterMethod() == ParameterMethod.setNull2) continue;
            context.getArgs()[1] = entry.getValue();
        }
    }

    protected final List<SqlExecuteEvent> createEvent(DispatcherResult metaData, SqlType sqlType, String originalSql, boolean needRowCopy) throws SQLException {
        if ((sqlType == SqlType.INSERT || sqlType == SqlType.UPDATE) && needRowCopy && metaData.needRowCopy()) {
            return SqlExecuteEventUtil.createEvent(metaData, sqlType, originalSql);
        }
        return null;
    }

    private void printLog(String dbIndex, List<Map<String, String>> actualTables) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("pool: " + dbIndex));
            StringBuilder buffer = new StringBuilder("actualTables: [");
            boolean firstElement = true;
            for (Map<String, String> tab : actualTables) {
                if (!firstElement) {
                    buffer.append(", ");
                } else {
                    firstElement = false;
                }
                buffer.append(tab);
            }
            buffer.append("]");
            log.debug((Object)buffer.toString());
        }
    }

    private void setResult(ExecutionPlan executionPlan, PipelineRuntimeInfo runtime) {
        runtime.setExecutionPlan(executionPlan);
    }

    public static void main(String[] args) {
        ExecutionPlanHandler ep = new ExecutionPlanHandler();
        String sql = "select /*+ INDEX(T, IDX_BILL_BILLING_STATUS)*/ ID, USER_ID, NICK,SOURCE, TRADE_NO, RATING_BILL_ID, EVENT_ID, CHARGE_ITEM_ID,BOOK_ITEM_ID, REL_RECEIVE_PAY, SUB_PROD_ID, FROM_DATE, END_DATE, BILL_CYCLE, FEE_TYPE,PAY_TIME, NOTIFY_TIME, PAYMENT_STATUS, SERV_ID, SERV_PROVIDE, TAOBAO_ALIPAY_ID,ALIPAY_ID, ALIPAY_EMAIL, IS_NEED, IS_FINISHED, GMT_CREATE, GMT_MODIFIED,ORDER_END_TIME,SERV_CODE,PROD_ID,PTRADE_ID,TRADE_ID,ACCUSE_ID,BILL_TIME,BILL_TYPE,ALI_PAY_TIME,RATE_RECEIVE_PAY,ALIPAY_COMMITE_FEE, ACCOUNT_BOOK_ID,ACCOUNT_BOOK_DETAIL_ID,STATUS,HASH_CODE,GROUP_ID,VERSION,SP_ID,SP_TYPE,AFTER_TAX,TAX,WRITEOFF_TIME,SC_RECORD_ID,STATICS_STATUS,FIN_AMOUNT,BAL_TYPE,FIN_AFTER_TAX,FIN_TAX,BIZ_TYPE,ITEM_INSTfrom BILL_BILLING T WHERE PAYMENT_STATUS in (0,2) and IS_FINISHED = 0 and STATUS != 3 and STATUS != 13 and SOURCE = 2 and BIZ_TYPE = 3";
        System.out.println(ep.replaceTableName(sql, "BILL_BILLING", "bill_billing_05", log));
    }
}

