/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.handler.executionplan;

import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.dispatcher.SingleLogicTableName;
import com.taobao.tddl.client.handler.AbstractHandler;
import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.client.jdbc.RealSqlContextImp;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlan;
import com.taobao.tddl.client.jdbc.executeplan.ExecutionPlanImp;
import com.taobao.tddl.common.jdbc.ParameterContext;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.DirectlyRouteCondition;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlDirectDispatchHandler
extends AbstractHandler {
    public static final String HANDLER_NAME = "SqlDirectDispatchHandler";
    private final Log log = LogFactory.getLog(SqlDirectDispatchHandler.class);

    @Override
    public void handleDown(DataBus dataBus) throws SQLException {
        if (AbstractHandler.FlowType.DIRECT == this.getPipeLineRuntimeInfo(dataBus).getFlowType()) {
            this.dispatch(dataBus);
        }
    }

    protected void dispatch(DataBus dataBus) throws SQLException {
        PipelineRuntimeInfo runtime = super.getPipeLineRuntimeInfo(dataBus);
        DirectlyRouteCondition directlyRouteCondition = runtime.getStartInfo().getDirectlyRouteCondition();
        String sql = runtime.getStartInfo().getSql();
        Map<Integer, ParameterContext> sqlParam = runtime.getStartInfo().getSqlParam();
        ExecutionPlan executionPlan = this.getDirectlyExecutionPlan(sql, sqlParam, directlyRouteCondition);
        this.setResult(executionPlan, runtime);
        this.debugLog(this.log, new Object[]{"sql direct dispatch end."});
    }

    private ExecutionPlan getDirectlyExecutionPlan(String sql, Map<Integer, ParameterContext> parameterSettings, DirectlyRouteCondition metaData) throws SQLException {
        ExecutionPlanImp executionPlanImp = new ExecutionPlanImp();
        Map<String, List<Map<String, String>>> shardTableMap = metaData.getShardTableMap();
        HashMap<String, List<RealSqlContext>> sqlMap = new HashMap<String, List<RealSqlContext>>(shardTableMap.size());
        for (Map.Entry<String, List<Map<String, String>>> entry : shardTableMap.entrySet()) {
            List<Map<String, String>> tableMapList = entry.getValue();
            ArrayList<RealSqlContextImp> realSqlContexts = new ArrayList<RealSqlContextImp>(tableMapList.size());
            boolean isUsingRealConnection = false;
            if (tableMapList.isEmpty()) {
                RealSqlContextImp realSqlContext = new RealSqlContextImp();
                realSqlContext.setArgument(parameterSettings);
                realSqlContext.setSql(this.replcaeMultiTableName(sql, new HashMap<String, String>()));
                realSqlContexts.add(realSqlContext);
                isUsingRealConnection = true;
            } else {
                for (Map<String, String> targetMap : entry.getValue()) {
                    isUsingRealConnection = !isUsingRealConnection;
                    RealSqlContextImp realSqlContext = new RealSqlContextImp();
                    realSqlContext.setArgument(parameterSettings);
                    realSqlContext.setRealTable(targetMap.values().toString());
                    realSqlContext.setSql(this.replcaeMultiTableName(sql, targetMap));
                    realSqlContexts.add(realSqlContext);
                }
            }
            sqlMap.put(entry.getKey(), realSqlContexts);
        }
        executionPlanImp.setSqlMap(sqlMap);
        executionPlanImp.setOriginalArgs(parameterSettings);
        executionPlanImp.setOrderByColumns(metaData.getOrderByMessages().getOrderbyList());
        executionPlanImp.setSkip(metaData.getSkip() == -1000 ? 0 : metaData.getSkip());
        executionPlanImp.setMax(metaData.getMax() == -1000 ? -1 : metaData.getMax());
        executionPlanImp.setGroupFunctionType(metaData.getGroupFunctionType());
        executionPlanImp.setVirtualTableName(new SingleLogicTableName(metaData.getVirtualTableName()));
        executionPlanImp.setEvents(null);
        executionPlanImp.setOriginalSql(sql);
        return executionPlanImp;
    }

    private void setResult(ExecutionPlan executionPlan, PipelineRuntimeInfo runtime) {
        runtime.setExecutionPlan(executionPlan);
    }
}

