/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.handler.rulematch;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.client.controller.DatabaseExecutionContext;
import com.taobao.tddl.client.controller.DatabaseExecutionContextImp;
import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.handler.AbstractHandler;
import com.taobao.tddl.interact.bean.ComparativeMapChoicer;
import com.taobao.tddl.interact.bean.Field;
import com.taobao.tddl.interact.bean.MatcherResult;
import com.taobao.tddl.interact.bean.TargetDB;
import com.taobao.tddl.interact.rule.VirtualTable;
import com.taobao.tddl.interact.rule.VirtualTableRoot;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.rule.le.TddlRuleInner;
import com.taobao.tddl.rule.le.exception.ResultCompareDiffException;
import com.taobao.tddl.sqlobjecttree.SqlParserResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleLeRouteMatchHandler
extends AbstractHandler {
    public static final String HANDLER_NAME = "RuleLeRouteMatchHandler";
    private final Log log = LogFactory.getLog(RuleLeRouteMatchHandler.class);
    private TddlRuleInner tddlRule = null;

    public RuleLeRouteMatchHandler(TddlRuleInner tddlRule) {
        this.tddlRule = tddlRule;
    }

    @Override
    public void handleDown(DataBus dataBus) throws SQLException {
        AbstractHandler.FlowType flowType = this.getPipeLineRuntimeInfo(dataBus).getFlowType();
        if (AbstractHandler.FlowType.DEFAULT == flowType || AbstractHandler.FlowType.NOSQLPARSE == flowType || AbstractHandler.FlowType.BATCH == flowType || AbstractHandler.FlowType.BATCH_NOSQLPARSER == flowType || AbstractHandler.FlowType.DBANDTAB_RC == flowType || AbstractHandler.FlowType.DBANDTAB_SQL == flowType) {
            try {
                this.match(dataBus);
            }
            catch (ResultCompareDiffException e) {
                throw new SQLException(e);
            }
        }
    }

    protected void match(DataBus dataBus) throws ResultCompareDiffException {
        PipelineRuntimeInfo runtime = super.getPipeLineRuntimeInfo(dataBus);
        SqlParserResult spr = runtime.getSqlParserResult();
        ComparativeMapChoicer choicer = spr.getComparativeMapChoicer();
        List<Object> sqlParameters = runtime.getStartInfo().getSqlParameters();
        SqlType sqlType = runtime.getStartInfo().getSqlType();
        Set<String> logicTableNames = runtime.getLogicTableNames();
        boolean isSqlParse = runtime.getIsSqlParsed();
        VirtualTableRoot root = runtime.getVirtualTableRoot();
        boolean needIdInGroup = root.isNeedIdInGroup();
        boolean completeDistinct = root.isCompleteDistinct();
        boolean isAllowReverseOutput = false;
        if (logicTableNames.size() == 1) {
            String logicTableName = logicTableNames.iterator().next();
            VirtualTable rule = root.getVirtualTable(StringUtil.toLowerCase((String)logicTableName));
            if (rule == null) {
                throw new IllegalArgumentException("\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u89c4\u5219,\u903b\u8f91\u8868:" + logicTableName);
            }
            isAllowReverseOutput = isSqlParse ? rule.isAllowReverseOutput() : false;
            MatcherResult matcherResult = null;
            matcherResult = spr.getInExpressionObjectList().size() > 0 && needIdInGroup ? this.tddlRule.routeMVerAndCompare(sqlType, logicTableName, choicer, sqlParameters, true) : this.tddlRule.routeMVerAndCompare(sqlType, logicTableName, choicer, sqlParameters, false);
            List targetDBs = matcherResult.getCalculationResult();
            List<DatabaseExecutionContext> databaseExecutionContexts = this.convertToDatabaseExecutionContext(logicTableName, targetDBs);
            this.setResult(databaseExecutionContexts, matcherResult, null, isAllowReverseOutput, rule.isNeedRowCopy(), rule.getUniqueKeys(), needIdInGroup, completeDistinct, runtime);
        } else {
            SqlParserResult sqlParserResult = runtime.getSqlParserResult();
            Map<String, String> alias = runtime.getAlias();
            int leftIndex = 0;
            int rightIndex = 1;
            ArrayList<List<TargetDB>> targetDBList = new ArrayList<List<TargetDB>>(logicTableNames.size());
            String[] logicTableArray = logicTableNames.toArray(new String[0]);
            LinkedList<DatabaseExecutionContext> databaseExecutionContexts = new LinkedList<DatabaseExecutionContext>();
            for (String logicTableName : logicTableArray) {
                VirtualTable rule = root.getVirtualTable(StringUtil.toLowerCase((String)logicTableName));
                if (rule == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("can't find table by " + logicTableName + " ,this logic table may dont need calc"));
                    continue;
                }
                if (isSqlParse && rule.isAllowReverseOutput()) {
                    isAllowReverseOutput = rule.isAllowReverseOutput();
                }
                MatcherResult matcherResult = this.tddlRule.routeMVerAndCompare(sqlType, logicTableName, sqlParserResult.getComparativeMapChoicer(), sqlParameters, true);
                targetDBList.add(matcherResult.getCalculationResult());
            }
            if (targetDBList.size() > 2) {
                throw new IllegalArgumentException("\u6682\u65f6\u4e0d\u652f\u6301\u4e09\u4e2a\u8868\u90fd\u8d70\u89c4\u5219\u7684join");
            }
            List left = (List)targetDBList.get(leftIndex);
            List right = (List)targetDBList.get(rightIndex);
            if (left.size() != right.size()) {
                throw new IllegalArgumentException("tddl \u76ee\u524d\u53ea\u652f\u6301\u591a\u8868\u5bf9\u7b49join");
            }
            if (left.size() == 1) {
                TargetDB leftTarget = (TargetDB)left.get(0);
                TargetDB rightTarget = (TargetDB)right.get(0);
                databaseExecutionContexts.add(this.buildOneDatabaseJoin(leftIndex, rightIndex, logicTableArray, leftTarget, rightTarget, alias));
            } else {
                if (left.size() == 0) {
                    throw new IllegalArgumentException("should not be here");
                }
                int count = 0;
                for (TargetDB leftTargetDB : left) {
                    for (TargetDB rightTargetDB : right) {
                        if (!leftTargetDB.getDbIndex().equals(rightTargetDB.getDbIndex())) continue;
                        databaseExecutionContexts.add(this.buildOneDatabaseJoin(leftIndex, rightIndex, logicTableArray, leftTargetDB, rightTargetDB, alias));
                        ++count;
                    }
                }
                if (count != left.size()) {
                    throw new IllegalArgumentException("\u5e93\u7684\u4e2a\u6570\u4e0d\u5339\u914d");
                }
            }
            this.setResult(databaseExecutionContexts, null, targetDBList, isAllowReverseOutput, false, null, needIdInGroup, completeDistinct, runtime);
        }
        this.debugLog(this.log, new Object[]{"rule match end."});
    }

    private List<DatabaseExecutionContext> convertToDatabaseExecutionContext(String logicTableName, List<TargetDB> targetDBs) {
        ArrayList<DatabaseExecutionContext> databaseExecutionContexts = new ArrayList<DatabaseExecutionContext>(targetDBs.size());
        for (TargetDB targetDB : targetDBs) {
            DatabaseExecutionContextImp dbec = new DatabaseExecutionContextImp();
            Set tableSet = targetDB.getTableNames();
            this.buildOneToOneJoin(targetDB.getDbIndex(), dbec, logicTableName, tableSet);
            dbec.setRealTableFieldMap(targetDB.getTableNameMap());
            databaseExecutionContexts.add(dbec);
        }
        return databaseExecutionContexts;
    }

    private void buildOneToManyJoin(String dbIndex, DatabaseExecutionContextImp dbec, String oneLogicTable, String one, String manyLogicTable, Set<String> manySet) {
        for (String many : manySet) {
            HashMap<String, String> tablePair = new HashMap<String, String>(1, 1.0f);
            tablePair.put(manyLogicTable, many);
            tablePair.put(oneLogicTable, one);
            dbec.addTablePair(tablePair);
        }
        dbec.setDbIndex(dbIndex);
    }

    private void buildOneToOneJoin(String dbIndex, DatabaseExecutionContextImp dbec, String oneLogicTable, Set<String> targetTables) {
        for (String one : targetTables) {
            HashMap<String, String> tablePair = new HashMap<String, String>(1, 1.0f);
            tablePair.put(oneLogicTable, one);
            dbec.addTablePair(tablePair);
        }
        dbec.setDbIndex(dbIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DatabaseExecutionContext buildOneDatabaseJoin(int leftIndex, int rightIndex, String[] logicTableArray, TargetDB leftTarget, TargetDB rightTarget, Map<String, String> alias) {
        DatabaseExecutionContextImp dbec = new DatabaseExecutionContextImp();
        if (!leftTarget.getDbIndex().equals(rightTarget.getDbIndex())) throw new IllegalArgumentException("tddl \u4e0d\u5141\u8bb8\u5728\u591a\u5e93\u4e0a\u6267\u884cjoin\u67e5\u8be2\uff0c\u6570\u636e\u5e93\u65e0\u6cd5\u652f\u6301");
        Map leftTableNameMap = leftTarget.getTableNameMap();
        Map rightTableNameMap = rightTarget.getTableNameMap();
        if (leftTableNameMap.size() == 1) {
            String one = (String)leftTableNameMap.keySet().iterator().next();
            String dbIndex = leftTarget.getDbIndex();
            String oneLogicTable = logicTableArray[0];
            String manyLogicTable = logicTableArray[1];
            Set<String> manySet = rightTableNameMap.keySet();
            this.buildOneToManyJoin(dbIndex, dbec, oneLogicTable, one, manyLogicTable, manySet);
            return dbec;
        } else if (rightTableNameMap.size() == 1) {
            String one = (String)rightTableNameMap.keySet().iterator().next();
            String dbIndex = rightTarget.getDbIndex();
            String oneLogicTable = logicTableArray[1];
            String manyLogicTable = logicTableArray[0];
            Set<String> manySet = leftTableNameMap.keySet();
            this.buildOneToManyJoin(dbIndex, dbec, oneLogicTable, one, manyLogicTable, manySet);
            return dbec;
        } else {
            if (leftTableNameMap.size() != rightTableNameMap.size()) throw new IllegalArgumentException("\u8868\u540d\u4e2a\u6570\u4e0d\u7b49\uff0ctddl \u76ee\u524d\u4e0d\u652f\u6301\u591a\u5bf9\u591a\u7b1b\u5361\u5c14\u79efjoin");
            for (Map.Entry entry : leftTableNameMap.entrySet()) {
                String leftTableName = (String)entry.getKey();
                int leftIndexNumberInt = this.getIndexNumberInt(leftTableName);
                dbec.setDbIndex(leftTarget.getDbIndex());
                for (Map.Entry rightEntry : rightTableNameMap.entrySet()) {
                    String rightTableName = (String)rightEntry.getKey();
                    int rightIndexNumberInt = this.getIndexNumberInt(rightTableName);
                    if (rightIndexNumberInt != leftIndexNumberInt) continue;
                    Field rightField = (Field)rightTableNameMap.get(entry.getKey());
                    if (rightField == null) {
                        throw new IllegalArgumentException("\u591a\u8868join\u8868\u540d\uff0c\u4e0d\u652f\u6301\u3002\u53ea\u6709\u5728\u591a\u8868\u8868\u89c4\u5219\u5b8c\u5168\u76f8\u540c\u7684\u573a\u666f\u4e0b\uff0c\u624d\u5141\u8bb8\u8fdb\u884c\u591a\u8868M*N join");
                    }
                    Field leftField = (Field)entry.getValue();
                    if (!rightField.equals((Object)leftField, alias)) {
                        throw new IllegalArgumentException("\u4e0d\u662f\u89c4\u5219\u5b8c\u5168\u76f8\u540c\u7684\u6570\u636e\u8868\u4e4b\u95f4\u8fdb\u884c\u7684join\uff0c\u4e0d\u652f\u6301\u3002\u53ea\u6709\u5728\u591a\u8868\u8868\u89c4\u5219\u5b8c\u5168\u76f8\u540c\u7684\u573a\u666f\u4e0b\uff0c\u624d\u5141\u8bb8\u8fdb\u884c\u591a\u8868M*N join");
                    }
                    String leftLogicTable = logicTableArray[leftIndex];
                    String rightLogicTable = logicTableArray[rightIndex];
                    HashMap<String, String> tablePair = new HashMap<String, String>(1);
                    tablePair.put(leftLogicTable, leftTableName);
                    tablePair.put(rightLogicTable, rightTableName);
                    dbec.addTablePair(tablePair);
                }
            }
        }
        return dbec;
    }

    private int getIndexNumberInt(String indexNumber) {
        int indexNumberInt;
        indexNumber = this.getIndexNumber(indexNumber);
        try {
            indexNumberInt = Integer.valueOf(indexNumber);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u8f6c\u6362\u683c\u5f0f\u9519\u8bef:" + indexNumber);
        }
        return indexNumberInt;
    }

    private String getIndexNumber(String indexNumber) {
        int lastIndex = StringUtil.lastIndexOf((String)indexNumber, (String)"_");
        indexNumber = StringUtil.substring((String)indexNumber, (int)(lastIndex + 1));
        return indexNumber;
    }

    private void setResult(List<DatabaseExecutionContext> dataBaseExecutionContext, MatcherResult matcherResult, List<List<TargetDB>> targetDBList, boolean isAllowReverseOutput, boolean needRowCopy, List<String> uniqueColumns, boolean needIdInGroup, boolean completeDistinct, PipelineRuntimeInfo runtime) {
        runtime.setMatcherResult(matcherResult);
        runtime.setAllowReverseOutput(isAllowReverseOutput);
        runtime.setTargetDBList(targetDBList);
        runtime.setDataBaseExecutionContext(dataBaseExecutionContext);
        runtime.setNeedRowCopy(needRowCopy);
        runtime.setUniqueColumns(uniqueColumns);
        runtime.setNeedIdInGroup(needIdInGroup);
        runtime.setCompleteDistinct(completeDistinct);
    }
}

