/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.handler.sqlparse;

import com.taobao.tddl.client.RouteCondition;
import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.handler.AbstractHandler;
import com.taobao.tddl.sqlobjecttree.SqlParserResult;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.JoinCondition;
import com.taobao.tddl.util.IDAndDateCondition.routeCondImp.RuleRouteCondition;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RouteConditionHandler
extends AbstractHandler {
    public static final String HANDLER_NAME = "RouteConditionHandler";
    private final Log log = LogFactory.getLog(RouteConditionHandler.class);

    @Override
    public void handleDown(DataBus dataBus) throws SQLException {
        AbstractHandler.FlowType flowType = this.getPipeLineRuntimeInfo(dataBus).getFlowType();
        if (AbstractHandler.FlowType.NOSQLPARSE == flowType || AbstractHandler.FlowType.DBANDTAB_RC == flowType || AbstractHandler.FlowType.BATCH_NOSQLPARSER == flowType) {
            this.parse(dataBus);
        }
    }

    protected void parse(DataBus dataBus) {
        PipelineRuntimeInfo runtime = this.getPipeLineRuntimeInfo(dataBus);
        RouteCondition rc = runtime.getStartInfo().getRc();
        if (rc instanceof RuleRouteCondition) {
            SqlParserResult sqlParserResult = ((RuleRouteCondition)rc).getSqlParserResult();
            this.setResult(sqlParserResult, false, runtime);
            if (rc instanceof JoinCondition) {
                runtime.setVirtualJoinTableNames(((JoinCondition)rc).getVirtualJoinTableNames());
            }
        } else {
            throw new IllegalArgumentException("wrong RouteCondition type:" + rc.getClass().getName());
        }
        this.debugLog(this.log, new Object[]{"route condition sql parse end."});
    }

    private void setResult(SqlParserResult sqlParserResult, boolean isRealSqlParsed, PipelineRuntimeInfo runtime) {
        runtime.setSqlParserResult(sqlParserResult);
        runtime.setLogicTableNames(sqlParserResult.getTableName());
        runtime.setIsSqlParsed(isRealSqlParsed);
    }
}

