/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.handler.sqlparse;

import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.handler.AbstractHandler;
import com.taobao.tddl.common.util.TStringUtil;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.parser.SQLParser;
import com.taobao.tddl.sqlobjecttree.SqlParserResult;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlParseHandler
extends AbstractHandler {
    public static final String HANDLER_NAME = "SqlParseHandler";
    private Log log = LogFactory.getLog(SqlParseHandler.class);

    @Override
    public void handleDown(DataBus dataBus) throws SQLException {
        AbstractHandler.FlowType flowType = this.getPipeLineRuntimeInfo(dataBus).getFlowType();
        if (AbstractHandler.FlowType.DEFAULT == flowType || AbstractHandler.FlowType.BATCH == flowType || AbstractHandler.FlowType.DBANDTAB_SQL == flowType) {
            this.preHandle(dataBus);
            this.parse(dataBus);
            this.afterHandle(dataBus);
        }
    }

    protected void preHandle(DataBus dataBus) {
        PipelineRuntimeInfo runtime = this.getPipeLineRuntimeInfo(dataBus);
        String groupHintStr = TStringUtil.getBetween((String)runtime.getStartInfo().getSql(), (String)"/*+TDDL_GROUP({", (String)"})*/");
        if (groupHintStr != null && !"".equals(groupHintStr.trim())) {
            String tempSql = TStringUtil.removeBetweenWithSplitor((String)runtime.getStartInfo().getSql(), (String)"/*+TDDL_GROUP({", (String)"})*/");
            runtime.getStartInfo().setSql(tempSql);
        }
        runtime.setGroupHintStr(groupHintStr);
    }

    protected void afterHandle(DataBus dataBus) {
        PipelineRuntimeInfo runtime = this.getPipeLineRuntimeInfo(dataBus);
        String sql = runtime.getStartInfo().getSql();
        String groupHintStr = runtime.getGroupHintStr();
        if (groupHintStr != null && !"".equals(groupHintStr.trim())) {
            StringBuilder sb = new StringBuilder("/*+TDDL_GROUP({");
            sb.append(groupHintStr);
            sb.append("})*/");
            sb.append(sql);
            runtime.getStartInfo().setSql(sb.toString());
        }
    }

    protected void parse(DataBus dataBus) {
        PipelineRuntimeInfo runtime = this.getPipeLineRuntimeInfo(dataBus);
        DBType dbType = runtime.getStartInfo().getDbType();
        boolean isMySQL = DBType.MYSQL.equals((Object)dbType);
        SQLParser sqlParser = runtime.getSQLParser();
        String sql = runtime.getStartInfo().getSql();
        SqlParserResult sqlParserResult = sqlParser.parse(sql, isMySQL);
        this.setResult(sqlParserResult, true, runtime);
        this.debugLog(this.log, new Object[]{"sql parse end."});
    }

    private void setResult(SqlParserResult sqlParserResult, boolean isRealSqlParsed, PipelineRuntimeInfo runtime) {
        runtime.setSqlParserResult(sqlParserResult);
        runtime.setLogicTableNames(sqlParserResult.getTableName());
        runtime.setIsSqlParsed(isRealSqlParsed);
    }
}

