/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.handler.validate;

import com.taobao.tddl.client.controller.ControllerUtils;
import com.taobao.tddl.client.controller.DatabaseExecutionContext;
import com.taobao.tddl.client.controller.DispatcherResultImp;
import com.taobao.tddl.client.controller.OrderByMessagesImp;
import com.taobao.tddl.client.databus.DataBus;
import com.taobao.tddl.client.databus.PipelineRuntimeInfo;
import com.taobao.tddl.client.dispatcher.DispatcherResult;
import com.taobao.tddl.client.dispatcher.EXECUTE_PLAN;
import com.taobao.tddl.client.dispatcher.MultiLogicTableNames;
import com.taobao.tddl.client.handler.AbstractHandler;
import com.taobao.tddl.interact.bean.MatcherResult;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.sqlobjecttree.SqlParserResult;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlDispatchHandler
extends AbstractHandler {
    public static final String HANDLER_NAME = "SqlDispatchHandler";
    private static final Log log = LogFactory.getLog(SqlDispatchHandler.class);

    @Override
    public void handleDown(DataBus dataBus) throws SQLException {
        AbstractHandler.FlowType flowType = this.getPipeLineRuntimeInfo(dataBus).getFlowType();
        if (AbstractHandler.FlowType.DEFAULT == flowType || AbstractHandler.FlowType.NOSQLPARSE == flowType || AbstractHandler.FlowType.BATCH == flowType || AbstractHandler.FlowType.BATCH_NOSQLPARSER == flowType || AbstractHandler.FlowType.DBANDTAB_RC == flowType || AbstractHandler.FlowType.DBANDTAB_SQL == flowType) {
            this.dispatch(dataBus);
        }
    }

    protected void dispatch(DataBus dataBus) throws SQLException {
        PipelineRuntimeInfo runtime = super.getPipeLineRuntimeInfo(dataBus);
        MatcherResult matcherResult = runtime.getMatcherResult();
        List<DatabaseExecutionContext> databaseExecutionContexts = runtime.getDataBaseExecutionContext();
        SqlParserResult sqlParserResult = runtime.getSqlParserResult();
        List<Object> sqlParameters = runtime.getStartInfo().getSqlParameters();
        DBType dbType = runtime.getStartInfo().getDbType();
        boolean allowReverseOutput = runtime.isAllowReverseOutput();
        boolean isSqlParsed = runtime.getIsSqlParsed();
        boolean needRowCopy = runtime.isNeedRowCopy();
        List<String> uniqueColumns = runtime.getUniqueColumns();
        boolean completeDistinct = runtime.isCompleteDistinct();
        DispatcherResult metaData = null;
        metaData = null != matcherResult ? this.getDispatcherResult(databaseExecutionContexts, matcherResult, sqlParserResult, sqlParameters, dbType, uniqueColumns, needRowCopy, allowReverseOutput, isSqlParsed, completeDistinct) : this.getDispatcherResult(databaseExecutionContexts, null, sqlParserResult, sqlParameters, dbType, Collections.EMPTY_LIST, false, allowReverseOutput, isSqlParsed, completeDistinct);
        this.setResult(metaData, runtime);
        this.debugLog(log, new Object[]{"sql dispatch end."});
    }

    protected DispatcherResult getDispatcherResult(List<DatabaseExecutionContext> databaseExecutionContexts, MatcherResult matcherResult, SqlParserResult sqlParserResult, List<Object> args, DBType dbType, List<String> uniqueColumnSet, boolean isNeedRowCopy, boolean isAllowReverseOutput, boolean isSqlParser, boolean completeDistinct) {
        DispatcherResultImp dispatcherResult = this.getTargetDatabaseMetaDataBydatabaseGroups(databaseExecutionContexts, sqlParserResult, args, isNeedRowCopy, isAllowReverseOutput);
        ControllerUtils.buildExecutePlan(dispatcherResult, databaseExecutionContexts);
        this.validGroupByFunction(sqlParserResult, dispatcherResult);
        this.validHavingByFunction(sqlParserResult, dispatcherResult);
        if (!completeDistinct) {
            this.validDistinctByFunction(sqlParserResult, dispatcherResult);
        }
        if (isSqlParser) {
            ControllerUtils.buildReverseOutput(args, sqlParserResult, dispatcherResult, DBType.MYSQL.equals((Object)dbType));
        }
        if (dispatcherResult.needRowCopy()) {
            this.buildUniqueKeyToBeReturn(sqlParserResult, args, uniqueColumnSet, dispatcherResult);
            if (matcherResult != null) {
                ControllerUtils.appendDatabaseSharedMetaData(matcherResult.getDatabaseComparativeMap(), dispatcherResult);
                ControllerUtils.appendTableSharedMetaData(matcherResult.getTableComparativeMap(), dispatcherResult);
            }
        }
        return dispatcherResult;
    }

    protected DispatcherResultImp getTargetDatabaseMetaDataBydatabaseGroups(List<DatabaseExecutionContext> targetDatabases, SqlParserResult sqlParserResult, List<Object> arguments, boolean isNeedRowCopy, boolean isAllowReverseOutput) {
        MultiLogicTableNames logicTablename = new MultiLogicTableNames();
        logicTablename.setLogicTables(sqlParserResult.getTableName());
        DispatcherResultImp dispatcherResultImp = new DispatcherResultImp(logicTablename, targetDatabases, isNeedRowCopy, isAllowReverseOutput, sqlParserResult.getSkip(arguments), sqlParserResult.getMax(arguments), new OrderByMessagesImp(sqlParserResult.getOrderByEles()), sqlParserResult.getGroupFuncType(), sqlParserResult.getDistinctColumn());
        return dispatcherResultImp;
    }

    protected void validGroupByFunction(SqlParserResult sqlParserResult, DispatcherResult dispatcherResult) {
        List groupByElement = sqlParserResult.getGroupByEles();
        if (groupByElement.size() != 0) {
            if (dispatcherResult.getDatabaseExecutePlan() == EXECUTE_PLAN.MULTIPLE) {
                throw new IllegalArgumentException("\u591a\u5e93\u7684\u60c5\u51b5\u4e0b\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528group by \u51fd\u6570");
            }
            if (dispatcherResult.getTableExecutePlan() == EXECUTE_PLAN.MULTIPLE) {
                throw new IllegalArgumentException("\u591a\u8868\u7684\u60c5\u51b5\u4e0b\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528group by\u51fd\u6570");
            }
        }
    }

    protected void validDistinctByFunction(SqlParserResult sqlParserResult, DispatcherResult dispatcherResult) {
        List dc = sqlParserResult.getDistinctColumn();
        if (dc != null && dc.size() != 0) {
            if (dispatcherResult.getDatabaseExecutePlan() == EXECUTE_PLAN.MULTIPLE) {
                throw new IllegalArgumentException("\u591a\u5e93\u7684\u60c5\u51b5\u4e0b\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528Distinct\u5173\u952e\u5b57");
            }
            if (dispatcherResult.getTableExecutePlan() == EXECUTE_PLAN.MULTIPLE) {
                throw new IllegalArgumentException("\u591a\u8868\u7684\u60c5\u51b5\u4e0b\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528Distinct\u5173\u952e\u5b57");
            }
        }
    }

    protected void validHavingByFunction(SqlParserResult sqlParserResult, DispatcherResult dispatcherResult) {
        boolean having = sqlParserResult.hasHavingCondition();
        if (having) {
            if (dispatcherResult.getDatabaseExecutePlan() == EXECUTE_PLAN.MULTIPLE) {
                throw new IllegalArgumentException("\u591a\u5e93\u7684\u60c5\u51b5\u4e0b\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528Having\u5173\u952e\u5b57");
            }
            if (dispatcherResult.getTableExecutePlan() == EXECUTE_PLAN.MULTIPLE) {
                throw new IllegalArgumentException("\u591a\u8868\u7684\u60c5\u51b5\u4e0b\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528Having\u5173\u952e\u5b57");
            }
        }
    }

    protected void buildUniqueKeyToBeReturn(SqlParserResult sqlParserResult, List<Object> args, List<String> uniqueColumnSet, DispatcherResultImp dispatcherResult) {
        HashSet<String> tempSet = new HashSet<String>(1);
        for (String str : uniqueColumnSet) {
            tempSet.clear();
            tempSet.add(str);
            Map uniqueMap = sqlParserResult.getComparativeMapChoicer().getColumnsMap(args, tempSet);
            if (uniqueMap.isEmpty()) continue;
            ControllerUtils.appendUniqueKeysMetaData(uniqueMap, dispatcherResult);
        }
    }

    private void setResult(DispatcherResult metaData, PipelineRuntimeInfo runtime) {
        runtime.setMetaData(metaData);
    }
}

