/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.taobao.tddl.client.jdbc.TConnectionImp;
import com.taobao.tddl.client.pipeline.PipelineFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class AllowReadLevelTConnection
extends TConnectionImp {
    protected String transactionKey;

    public AllowReadLevelTConnection(boolean enableProfileRealDBAndTables, PipelineFactory pipelineFactory) {
        super(enableProfileRealDBAndTables, pipelineFactory);
    }

    @Override
    public Connection getConnection(String dbIndex, boolean goSlave) throws SQLException {
        Connection conn = (Connection)this.connectionMap.get(dbIndex);
        if (conn == null) {
            DataSource datasource = (DataSource)this.dsMap.get(dbIndex);
            if (datasource == null) {
                throw new SQLException("can't find datasource by your dbIndex :" + dbIndex);
            }
            if (this.isAutoCommit) {
                conn = datasource.getConnection();
                conn.setAutoCommit(this.isAutoCommit);
                this.connectionMap.put(dbIndex, conn);
            } else {
                boolean needSetAutoCommit = this.validThrowSQLException(dbIndex, goSlave);
                conn = datasource.getConnection();
                if (needSetAutoCommit) {
                    conn.setAutoCommit(this.isAutoCommit);
                }
                this.connectionMap.put(dbIndex, conn);
            }
            return conn;
        }
        if (!this.isAutoCommit) {
            this.validThrowSQLException(dbIndex, goSlave);
        }
        return conn;
    }

    @Override
    protected List<SQLException> setAutoCommitTrue2False(boolean autoCommit, List<SQLException> sqlExceptions) throws SQLException {
        this.validTransactionCondition(false);
        boolean firstIn = true;
        for (Map.Entry<String, Connection> entry : this.connectionMap.entrySet()) {
            if (!this.isTransactionConnection((String)entry.getKey())) continue;
            if (firstIn) {
                firstIn = false;
                this.transactionKey = (String)entry.getKey();
            }
            sqlExceptions = this.setAutoCommitAndPutSQLExceptionToList(autoCommit, sqlExceptions, entry);
        }
        return sqlExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<SQLException> setAutoCommitFalse2True(boolean autoCommit, List<SQLException> sqlExceptions) {
        try {
            List<SQLException> list = super.setAutoCommitFalse2True(autoCommit, sqlExceptions);
            return list;
        }
        finally {
            this.transactionKey = null;
        }
    }

    @Override
    protected boolean isTransactionConnection(String dbIndex) {
        if (dbIndex == null) {
            return true;
        }
        return dbIndex.equals(this.transactionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryClose(String dbIndex) throws SQLException {
        Connection conn = (Connection)this.connectionMap.get(dbIndex);
        if (conn == null) {
            log.warn((Object)"should not be here ");
            return;
        }
        if (this.isAutoCommit && this.openedStatements.size() <= 1) {
            try {
                if (this.transactionKey != null && this.transactionKey.equals(dbIndex)) {
                    log.warn((Object)("should not be here! transaction Key is not null !" + this.transactionKey));
                    this.transactionKey = null;
                }
                conn.close();
            }
            finally {
                this.connectionMap.remove(dbIndex);
            }
        }
    }

    protected boolean validThrowSQLException(String dbIndex, boolean isGoSlave) throws SQLException {
        if (this.transactionKey == null) {
            if (!isGoSlave) {
                this.transactionKey = dbIndex;
                return true;
            }
            return false;
        }
        if (!this.transactionKey.equals(dbIndex) && !isGoSlave) {
            throw new SQLException("\u4e0d\u5141\u8bb8\u5199\u5165\u5230\u591a\u4e2a\u4e0d\u540c\u7684\u6570\u636e\u5e93\u8282\u70b9\u4e2d\uff01");
        }
        return false;
    }
}

