/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.taobao.tddl.client.jdbc.RealSqlContext;
import com.taobao.tddl.common.Monitor;
import java.sql.SQLException;
import java.util.List;

public abstract class ExecuteSQLProfiler {
    private boolean enableProfileRealDBAndTables;
    protected long timeoutForEachTable = 100L;
    public static final long DEFAULT_TIMEOUT_FOR_EACH_TABLE = 100L;
    private long timeoutThreshold;

    protected void profileRealDatabaseAndTables(String database, RealSqlContext targetSql, long during) {
        if (this.isEnableProfileRealDBAndTables()) {
            if (during >= this.timeoutForEachTable) {
                Monitor.matrixSqlAdd((String)Monitor.buildExecuteDBAndTableKey1((String)database, (String)targetSql.getRealTable()), (String)Monitor.buildExecuteSqlKey2((String)targetSql.getSql()), (String)"EXECUTE_A_SQL_TIMEOUT", (long)during, (long)1L);
            } else {
                Monitor.matrixSqlAdd((String)Monitor.buildExecuteDBAndTableKey1((String)database, (String)targetSql.getRealTable()), (String)Monitor.buildExecuteSqlKey2((String)targetSql.getSql()), (String)"EXECUTE_A_SQL_SUCCESS", (long)during, (long)1L);
            }
        }
    }

    protected void profileNumberOfDBAndTablesOnly(String virtualTableName, int databaseSize, int targetTablesSize, String sql) {
        Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_SUCCESS_DBTAB", (long)databaseSize, (long)targetTablesSize);
    }

    protected void profileNumberOfDBAndTablesAndDuringTime(String virtualTableName, int databaseSize, int targetTablesSize, String sql, long elapsedTime) {
        if (elapsedTime > this.timeoutThreshold) {
            Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_TIMEOUT", (long)elapsedTime, (long)1L);
            Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_TIMEOUT_DBTAB", (long)databaseSize, (long)targetTablesSize);
        } else {
            Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_SUCCESS", (long)elapsedTime, (long)1L);
            Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_SUCCESS_DBTAB", (long)databaseSize, (long)targetTablesSize);
        }
    }

    protected void profileDuringTime(List<SQLException> exceptions, String virtualTableName, String sql, long elapsedTime) {
        if (exceptions != null && !exceptions.isEmpty()) {
            Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_WITH_EXCEPTION", (long)elapsedTime, (long)1L);
        } else if (elapsedTime > this.timeoutThreshold) {
            Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_TIMEOUT", (long)elapsedTime, (long)1L);
        } else {
            Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_SUCCESS", (long)elapsedTime, (long)1L);
        }
    }

    protected void profileRealDatabaseAndTablesWithException(String database, RealSqlContext targetSql, long during) {
        if (this.isEnableProfileRealDBAndTables()) {
            Monitor.matrixSqlAdd((String)Monitor.buildExecuteDBAndTableKey1((String)database, (String)targetSql.getRealTable()), (String)Monitor.buildExecuteSqlKey2((String)targetSql.getSql()), (String)"EXECUTE_A_SQL_WITH_EXCEPTION", (long)during, (long)1L);
        }
    }

    protected void profileWithException(List<SQLException> exceptions, String virtualTableName, String sql, long elapsedTime) {
        if (exceptions != null && !exceptions.isEmpty()) {
            Monitor.matrixSqlAdd((String)Monitor.buildTableKey1((String)virtualTableName), (String)Monitor.buildExecuteSqlKey2((String)sql), (String)"EXECUTE_A_SQL_WITH_EXCEPTION", (long)elapsedTime, (long)1L);
        }
    }

    public boolean isEnableProfileRealDBAndTables() {
        return Monitor.isStatRealDbInWrapperDs == null ? this.enableProfileRealDBAndTables : Monitor.isStatRealDbInWrapperDs;
    }

    public void setEnableProfileRealDBAndTables(boolean enableProfileRealDBAndTables) {
        this.enableProfileRealDBAndTables = enableProfileRealDBAndTables;
    }

    public long getTimeoutForEachTable() {
        return this.timeoutForEachTable;
    }

    public void setTimeoutForEachTable(long timeoutForEachTable) {
        this.timeoutForEachTable = timeoutForEachTable;
    }

    public long getTimeoutThreshold() {
        return this.timeoutThreshold;
    }

    public void setTimeoutThreshold(long timeoutThreshold) {
        this.timeoutThreshold = timeoutThreshold;
    }
}

