/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.client.jdbc;

import com.taobao.tddl.client.controller.ColumnMetaData;
import com.taobao.tddl.client.dispatcher.DispatcherResult;
import com.taobao.tddl.client.jdbc.DefaultSqlExecuteEvent;
import com.taobao.tddl.client.jdbc.SqlExecuteEvent;
import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.interact.rule.enumerator.Enumerator;
import com.taobao.tddl.interact.rule.enumerator.EnumeratorImp;
import com.taobao.tddl.interact.sqljep.Comparative;
import com.taobao.tddl.interact.sqljep.ComparativeBaseList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SqlExecuteEventUtil {
    private static final Enumerator enumerator = new EnumeratorImp();

    private static SqlExecuteEvent createEvent(DispatcherResult metaData, SqlType sqlType, String originalSql, Object primaryKeyValue) throws SQLException {
        DefaultSqlExecuteEvent event = new DefaultSqlExecuteEvent();
        event.setReplicated(metaData.needRowCopy());
        event.setSqlType(sqlType);
        event.setLogicTableName(metaData.getVirtualTableName().toString());
        event.setPrimaryKeyColumn(metaData.getPrimaryKey().key.toLowerCase());
        event.setPrimaryKeyValue(primaryKeyValue);
        if (SqlExecuteEventUtil.hasAvalue(metaData.getSplitDB())) {
            event.setDatabaseShardColumn(metaData.getSplitDB().get((int)0).key.toLowerCase());
            event.setDatabaseShardValue(metaData.getSplitDB().get((int)0).value.getValue());
        }
        if (SqlExecuteEventUtil.hasAvalue(metaData.getSplitTab())) {
            event.setTableShardColumn(metaData.getSplitTab().get((int)0).key.toLowerCase());
            event.setTableShardValue(metaData.getSplitTab().get((int)0).value.getValue());
        }
        event.setSql(originalSql);
        return event;
    }

    private static boolean hasAvalue(List<ColumnMetaData> columnMetaDatas) {
        return columnMetaDatas != null && !columnMetaDatas.isEmpty() && columnMetaDatas.get((int)0).key != null && columnMetaDatas.get((int)0).key.length() > 0 && columnMetaDatas.get((int)0).value != null;
    }

    private static boolean isConfuse(ColumnMetaData uniqeMeta, List<ColumnMetaData> splitMetas) {
        Comparative value;
        return SqlExecuteEventUtil.hasAvalue(splitMetas) && !uniqeMeta.key.equals(splitMetas.get((int)0).key) && ((value = splitMetas.get((int)0).value) instanceof ComparativeBaseList || value.getComparison() != 3);
    }

    public static List<SqlExecuteEvent> createEvent(DispatcherResult metaData, SqlType sqlType, String originalSql) throws SQLException {
        if (metaData.getPrimaryKey() == null || metaData.getPrimaryKey().key == null || metaData.getPrimaryKey().key.length() == 0) {
            throw new SQLException("\u5206\u5e93\u5206\u8868\u89c4\u5219\u7f3a\u5c11\u552f\u4e00\u952e\u9879");
        }
        if (metaData.getPrimaryKey().value == null) {
            throw new SQLException("SQL\u4e2d\u6ca1\u5e26\u552f\u4e00\u952e, sql = " + originalSql);
        }
        if (metaData.getSplitDB() != null && metaData.getSplitDB().size() > 1) {
            throw new SQLException("TDDL\u884c\u590d\u5236\u76ee\u524d\u4e0d\u652f\u6301sql\u4e2d\u7684\u5206\u5e93\u5b57\u6bb5\u591a\u4e8e\u4e24\u4e2a\uff1a" + originalSql);
        }
        if (metaData.getSplitTab() != null && metaData.getSplitTab().size() > 1) {
            throw new SQLException("TDDL\u884c\u590d\u5236\u76ee\u524d\u4e0d\u652f\u6301sql\u4e2d\u7684\u5206\u8868\u5b57\u6bb5\u591a\u4e8e\u4e24\u4e2a\uff1a" + originalSql);
        }
        if (SqlExecuteEventUtil.isConfuse(metaData.getPrimaryKey(), metaData.getSplitDB())) {
            throw new SQLException("\u552f\u4e00\u952e\u4e0d\u662f\u5206\u5e93\u952e, \u4e14\u5206\u5e93\u952e\u5728sql\u4e2d\u6709\u6761\u4ef6\uff0c\u5e76\u4e14\u4e0d\u662f\u4ec5\u4ec5\u4e00\u4e2a\u7b49\u4e8e\u6761\u4ef6\uff1a" + originalSql);
        }
        if (SqlExecuteEventUtil.isConfuse(metaData.getPrimaryKey(), metaData.getSplitTab())) {
            throw new SQLException("\u552f\u4e00\u952e\u4e0d\u662f\u5206\u8868\u952e, \u4e14\u5206\u5e93\u952e\u5728sql\u4e2d\u6709\u6761\u4ef6\uff0c\u5e76\u4e14\u4e0d\u662f\u4ec5\u4ec5\u4e00\u4e2a\u7b49\u4e8e\u6761\u4ef6\uff1a" + originalSql);
        }
        boolean needMergeValueInCloseRange = false;
        ArrayList<SqlExecuteEvent> res = new ArrayList<SqlExecuteEvent>();
        Set uniqeKeyValues = enumerator.getEnumeratedValue((Comparable)metaData.getPrimaryKey().value, null, null, needMergeValueInCloseRange);
        for (Object uniqeKeyValue : uniqeKeyValues) {
            res.add(SqlExecuteEventUtil.createEvent(metaData, sqlType, originalSql, uniqeKeyValue));
        }
        return res;
    }
}

